<?php
/**
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link      http://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Controller\Controller;
use Cake\Database\Type;
use Cake\Event\Event;

Type::build('date')
    ->useLocaleParser()
    ->setLocaleFormat('dd/MM/yyyy');
Type::build('datetime')
    ->useLocaleParser()
    ->setLocaleFormat('dd/MM/yyyy HH:mm:ss');
Type::build('timestamp')
    ->useLocaleParser()
    ->setLocaleFormat('dd/MM/yyyy HH:mm:ss');

// Habilita o parseamento de decimal localizaddos
Type::build('decimal')
    ->useLocaleParser();
Type::build('float')
    ->useLocaleParser();
/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @link http://book.cakephp.org/3.0/en/controllers.html#the-app-controller
 */
class AppController extends Controller
{
    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like loading components.
     *
     * e.g. `$this->loadComponent('Security');`
     *
     * @return void
     */

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('RequestHandler');
        $this->loadComponent('Flash');
        $this->viewBuilder()->theme('TwitterBootstrap');
        $this->set('project_name', 'Projeto GH');
        $this->loadComponent('Auth', [
            'authorize'            => 'Controller',
            'authenticate'         => [
                'Form' => [
                    'fields' => [
                        'username' => 'email',
                        'password' => 'password',
                    ],
                ],
            ],
            //'unauthorizedRedirect'=>false
            //'unauthorizedRedirect' => $this->referer()
            'unauthorizedRedirect' => [
                'controller' => 'users',
                'action'     => 'login',
                'prefix'     => false,
            ],

        ]);
    }

    public function isAuthorized($user)
    {
        //return false;
        $action = $this->request->params['action'];
        return $this->Permission->hasPermission($user['role_name'], 'users', $action);
    }

    public function beforeFilter(Event $event)
    {
        $this->set('isLogged', $this->Auth->user());

        $this->set('currentController', $this->request->params['controller']);

        $session = $this->request->session();
        $this->set('unit_id', $session->read('selected-unit'));

        if ($session->read('selected-hospitalization')) {
            $this->set('hospitalization_id', $session->read('selected-hospitalization'));
        }

        if ($session->read('selected-patient-name')) {
            $this->set('patient_name', $session->read('selected-patient-name'));
        }

        if ($session->read('selected-hospitalization-date')) {
            $this->set('hospitalization_date', $session->read('selected-hospitalization-date'));
        }

        if ($session->read('selected-unit-name')) {
            $this->set('unit_name', $session->read('selected-unit-name'));
        }
    }

    /**
     * Before render callback.
     *
     * @param \Cake\Event\Event $event The beforeRender event.
     * @return void
     */
    public function beforeRender(Event $event)
    {
        if (!array_key_exists('_serialize', $this->viewVars) &&
            in_array($this->response->type(), ['application/json', 'application/xml'])
        ) {
            $this->set('_serialize', true);
        }

    }
}
