<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * SofaEscores Controller
 *
 * @property \App\Model\Table\SofaEscoresTable $SofaEscores
 */
class SofaEscoresController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Sofa Escore');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selectedted-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'SofaEscores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $sofaEscores = $this->paginate($this->SofaEscores);

        $this->set(compact('sofaEscores'));
        $this->set('_serialize', ['sofaEscores']);
    }

    /**
     * View method
     *
     * @param string|null $id Sofa Escore id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $sofaEscore = $this->SofaEscores->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('sofaEscore', $sofaEscore);
        $this->set('_serialize', ['sofaEscore']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $sofaEscore = $this->SofaEscores->newEntity();
        if ($this->request->is('post')) {
            $sofaEscore = $this->SofaEscores->patchEntity($sofaEscore, $this->request->data);
            if ($this->SofaEscores->save($sofaEscore)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            } else {
                $this->Flash->error(__('o registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->SofaEscores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('sofaEscore', 'hospitalizations'));
        $this->set('_serialize', ['sofaEscore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Sofa Escore id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $sofaEscore = $this->SofaEscores->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $sofaEscore = $this->SofaEscores->patchEntity($sofaEscore, $this->request->data);
            if ($this->SofaEscores->save($sofaEscore)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            } else {
                $this->Flash->error(__('o registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->SofaEscores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('sofaEscore', 'hospitalizations'));
        $this->set('_serialize', ['sofaEscore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Sofa Escore id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $sofaEscore = $this->SofaEscores->get($id);
        if ($this->SofaEscores->delete($sofaEscore)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
    }
}
