<?php
namespace App\Model\Table;

use App\Model\Entity\DefectsAndAnomaly;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * DefectsAndAnomalies Model
 *
 * @property \Cake\ORM\Association\BelongsTo $DefectTypes
 * @property \Cake\ORM\Association\BelongsToMany $Diagnostics
 */
class DefectsAndAnomaliesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('defects_and_anomalies');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->belongsTo('DefectTypes', [
            'foreignKey' => 'defect_type_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsToMany('Diagnostics', [
            'foreignKey' => 'defects_and_anomaly_id',
            'targetForeignKey' => 'diagnostic_id',
            'joinTable' => 'defects_and_anomalies_diagnostics'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['defect_type_id'], 'DefectTypes'));
        return $rules;
    }
}
