<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Care']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Screenings']), ['controller' => 'Screenings', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Screening']), ['controller' => 'Screenings', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Diagnostics']), ['controller' => 'Diagnostics', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Diagnostic']), ['controller' => 'Diagnostics', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Medication Reconciliations']), ['controller' => 'MedicationReconciliations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Medication Reconciliation']), ['controller' => 'MedicationReconciliations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="medicalCares index col-md-10 columns content">
    <h3>Medical Cares</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('origin') ?></th>
                <th><?= $this->Paginator->sort('register_number') ?></th>
                <th><?= $this->Paginator->sort('allergy') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('hda') ?></th>
                <th><?= $this->Paginator->sort('hpp') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($medicalCares as $medicalCare): ?>
            <tr>
                <td><?= $this->Number->format($medicalCare->id) ?></td>
                <td><?= h($medicalCare->origin) ?></td>
                <td><?= h($medicalCare->register_number) ?></td>
                <td><?= h($medicalCare->allergy) ?></td>
                <td><?= h($medicalCare->created) ?></td>
                <td><?= h($medicalCare->hda) ?></td>
                <td><?= h($medicalCare->hpp) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $medicalCare->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $medicalCare->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $medicalCare->id], ['confirm' => __('Are you sure you want to delete # {0}?', $medicalCare->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>