<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Discharge']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="discharges index col-md-10 columns content">
    <h3>Discharges</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('evolucao_intercorrencias_medicacoes_relevantes') ?></th>
                <th><?= $this->Paginator->sort('condicoes_de_alta_transferencia') ?></th>
                <th><?= $this->Paginator->sort('destino') ?></th>
                <th><?= $this->Paginator->sort('retornar_ao_consultorio_em_x_dias') ?></th>
                <th><?= $this->Paginator->sort('aos_cuidados_de') ?></th>
                <th><?= $this->Paginator->sort('observacoes') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($discharges as $discharge): ?>
            <tr>
                <td><?= $this->Number->format($discharge->id) ?></td>
                <td><?= h($discharge->evolucao_intercorrencias_medicacoes_relevantes) ?></td>
                <td><?= h($discharge->condicoes_de_alta_transferencia) ?></td>
                <td><?= h($discharge->destino) ?></td>
                <td><?= h($discharge->retornar_ao_consultorio_em_x_dias) ?></td>
                <td><?= h($discharge->aos_cuidados_de) ?></td>
                <td><?= h($discharge->observacoes) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $discharge->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $discharge->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $discharge->id], ['confirm' => __('Are you sure you want to delete # {0}?', $discharge->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>