<?php
namespace App\Model\Table;

use App\Model\Entity\DailyBundle;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * DailyBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Bundles
 */
class DailyBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('daily_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Bundles', [
            'foreignKey' => 'bundle_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('higienizacao_diaria_com_solucao_dergermante_da_genitalia')
            ->allowEmpty('higienizacao_diaria_com_solucao_dergermante_da_genitalia');

        $validator
            ->boolean('manter_bolsa_coletora_abaixo_do_nivel_da_bexiga')
            ->allowEmpty('manter_bolsa_coletora_abaixo_do_nivel_da_bexiga');

        $validator
            ->boolean('manter_bolsa_coletora_com_capacidade_maxima_de_2_3')
            ->allowEmpty('manter_bolsa_coletora_com_capacidade_maxima_de_2_3');

        $validator
            ->boolean('fixacao_do_cateter_seguro_para_evitar_qualquer_movimento')
            ->allowEmpty('fixacao_do_cateter_seguro_para_evitar_qualquer_movimento');

        $validator
            ->boolean('revisao_diaria_da_indicacao_de_permanencia_do_cateter')
            ->allowEmpty('revisao_diaria_da_indicacao_de_permanencia_do_cateter');

        $validator
            ->boolean('sinal_de_uretrite')
            ->allowEmpty('sinal_de_uretrite');

        $validator
            ->boolean('transporte_realizado_com_clampeamento_do_sistema_coletor')
            ->allowEmpty('transporte_realizado_com_clampeamento_do_sistema_coletor');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['bundle_id'], 'Bundles'));
        return $rules;
    }
}
