<?php
namespace App\Model\Table;

use App\Model\Entity\MedicationsHistoric;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * MedicationsHistoric Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Signs
 * @property \Cake\ORM\Association\BelongsTo $Medications
 */
class MedicationsHistoricTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('medications_historic');
        $this->displayField('name');
        $this->primaryKey(['id', 'sign_id']);

        $this->addBehavior('Timestamp');

        $this->belongsTo('Signs', [
            'foreignKey' => 'sign_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Medications', [
            'foreignKey' => 'medication_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('name');

        $validator
            ->allowEmpty('dosage');

        $validator
            ->allowEmpty('channel');

        $validator
            ->allowEmpty('frequency');

        $validator
            ->date('start_date')
            ->allowEmpty('start_date');

        $validator
            ->date('end_date')
            ->allowEmpty('end_date');

        $validator
            ->boolean('is_antibiotic')
            ->allowEmpty('is_antibiotic');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['sign_id'], 'Signs'));
        $rules->add($rules->existsIn(['medication_id'], 'Medications'));
        return $rules;
    }
}
