<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Curb Score']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="curbScores index col-md-10 columns content">
    <h3>Curb Scores</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('presenca_de_confusao_mental') ?></th>
                <th><?= $this->Paginator->sort('ureia_acima_de_50') ?></th>
                <th><?= $this->Paginator->sort('frequencia_respiratoria') ?></th>
                <th><?= $this->Paginator->sort('pressao_arterial') ?></th>
                <th><?= $this->Paginator->sort('idade_maior_de_65_anos') ?></th>
                <th><?= $this->Paginator->sort('data_de_realizacao') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($curbScores as $curbScore): ?>
            <tr>
                <td><?= $this->Number->format($curbScore->id) ?></td>
                <td><?= h($curbScore->presenca_de_confusao_mental) ?></td>
                <td><?= h($curbScore->ureia_acima_de_50) ?></td>
                <td><?= h($curbScore->frequencia_respiratoria) ?></td>
                <td><?= h($curbScore->pressao_arterial) ?></td>
                <td><?= h($curbScore->idade_maior_de_65_anos) ?></td>
                <td><?= h($curbScore->data_de_realizacao) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $curbScore->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $curbScore->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $curbScore->id], ['confirm' => __('Are you sure you want to delete # {0}?', $curbScore->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>