<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Daily Safety Checklist']), ['action' => 'edit', $dailySafetyChecklist->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Daily Safety Checklist']), ['action' => 'delete', $dailySafetyChecklist->id], ['confirm' => __('Are you sure you want to delete # {0}?', $dailySafetyChecklist->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Daily Safety Checklists']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Daily Safety Checklist']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Procedures']), ['controller' => 'Procedures', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Procedure']), ['controller' => 'Procedures', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="dailySafetyChecklists view col-lg-10 col-md-9">
    <h3><?= h($dailySafetyChecklist->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Cabeceira De Leito Elevado</th>
            <td><?= h($dailySafetyChecklist->cabeceira_de_leito_elevado) ?></td>
        </tr>
        <tr>
            <th>Prevenção De Lesao Aguda De Mucosa Gastrica</th>
            <td><?= h($dailySafetyChecklist->prevenção_de_lesao_aguda_de_mucosa_gastrica) ?></td>
        </tr>
        <tr>
            <th>Profilaxia De Tev</th>
            <td><?= h($dailySafetyChecklist->profilaxia_de_tev) ?></td>
        </tr>
        <tr>
            <th>Suporte Nutricional</th>
            <td><?= h($dailySafetyChecklist->suporte_nutricional) ?></td>
        </tr>
        <tr>
            <th>Total De Insulina Sub Cutanea Nas 24 Horas</th>
            <td><?= h($dailySafetyChecklist->total_de_insulina_sub_cutanea_nas_24_horas) ?></td>
        </tr>
        <tr>
            <th>Total De Insulina Venosa Nas 24 Horas</th>
            <td><?= h($dailySafetyChecklist->total_de_insulina_venosa_nas_24_horas) ?></td>
        </tr>
        <tr>
            <th>Total De Glicemias</th>
            <td><?= h($dailySafetyChecklist->total_de_glicemias) ?></td>
        </tr>
        <tr>
            <th>Hospitalization</th>
            <td><?= $dailySafetyChecklist->has('hospitalization') ? $this->Html->link($dailySafetyChecklist->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $dailySafetyChecklist->hospitalization->id]) : '' ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($dailySafetyChecklist->id) ?></td>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($dailySafetyChecklist->created) ?></tr>
        </tr>
        <tr>
            <th>Modified</th>
            <td><?= h($dailySafetyChecklist->modified) ?></tr>
        </tr>
        <tr>
            <th>Protocolo De Controle Glicemico</th>
            <td><?= $dailySafetyChecklist->protocolo_de_controle_glicemico ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Fez Insulina Venosa</th>
            <td><?= $dailySafetyChecklist->fez_insulina_venosa ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Sedacao</th>
            <td><?= $dailySafetyChecklist->sedacao ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Sob Analgesia</th>
            <td><?= $dailySafetyChecklist->sob_analgesia ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Delirium</th>
            <td><?= $dailySafetyChecklist->delirium ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Teve Dor Nas Ultimas 24 Horas</th>
            <td><?= $dailySafetyChecklist->teve_dor_nas_ultimas_24_horas ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Ventilacao Mecanica Invasiva</th>
            <td><?= $dailySafetyChecklist->ventilacao_mecanica_invasiva ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Pa2 Fio2 Menor Que 300</th>
            <td><?= $dailySafetyChecklist->pa2_fio2_menor_que_300 ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Volume Corrente Menor Que 8</th>
            <td><?= $dailySafetyChecklist->volume_corrente_menor_que_8 ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Pressao De Plato Menor Que 30</th>
            <td><?= $dailySafetyChecklist->pressao_de_plato_menor_que_30 ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Iniciar Desmane</th>
            <td><?= $dailySafetyChecklist->iniciar_desmane ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Iniciar Peca T</th>
            <td><?= $dailySafetyChecklist->iniciar_peca_t ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Cateter Venoso Central</th>
            <td><?= $dailySafetyChecklist->cateter_venoso_central ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Cateter Arterial Can Be Removed</th>
            <td><?= $dailySafetyChecklist->cateter_arterial_can_be_removed ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Cateter Vesical De Demora</th>
            <td><?= $dailySafetyChecklist->cateter_vesical_de_demora ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Cateter Vesical De Demora Can Be Removed</th>
            <td><?= $dailySafetyChecklist->cateter_vesical_de_demora_can_be_removed ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Antibioticos</th>
            <td><?= $dailySafetyChecklist->antibioticos ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Antibioticos Can Be Removed</th>
            <td><?= $dailySafetyChecklist->antibioticos_can_be_removed ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Corticoesteroides</th>
            <td><?= $dailySafetyChecklist->corticoesteroides ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Corticoesteroides Can Be Removed</th>
            <td><?= $dailySafetyChecklist->corticoesteroides_can_be_removed ? __('Yes') : __('No'); ?></td>
         </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Procedures']) ?></h4>
        <?php if (!empty($dailySafetyChecklist->procedures)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Description</th>
                <th>Can Be Removed</th>
                <th>Daily Safety Checklist Id</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($dailySafetyChecklist->procedures as $procedures): ?>
            <tr>
                <td><?= h($procedures->id) ?></td>
                <td><?= h($procedures->description) ?></td>
                <td><?= h($procedures->can_be_removed) ?></td>
                <td><?= h($procedures->daily_safety_checklist_id) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Procedures', 'action' => 'view', $procedures->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Procedures', 'action' => 'edit', $procedures->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Procedures', 'action' => 'delete', $procedures->id], ['confirm' => __('Are you sure you want to delete # {0}?', $procedures->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
