<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * AreasOfOccupation Controller
 *
 * @property \App\Model\Table\AreasOfOccupationTable $AreasOfOccupation
 */
class AreasOfOccupationController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $areasOfOccupation = $this->paginate($this->AreasOfOccupation);

        $this->set(compact('areasOfOccupation'));
        $this->set('_serialize', ['areasOfOccupation']);
    }

    /**
     * View method
     *
     * @param string|null $id Areas Of Occupation id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $areasOfOccupation = $this->AreasOfOccupation->get($id, [
            'contain' => []
        ]);

        $this->set('areasOfOccupation', $areasOfOccupation);
        $this->set('_serialize', ['areasOfOccupation']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $areasOfOccupation = $this->AreasOfOccupation->newEntity();
        if ($this->request->is('post')) {
            $areasOfOccupation = $this->AreasOfOccupation->patchEntity($areasOfOccupation, $this->request->data);
            if ($this->AreasOfOccupation->save($areasOfOccupation)) {
                $this->Flash->success(__('The areas of occupation has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The areas of occupation could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('areasOfOccupation'));
        $this->set('_serialize', ['areasOfOccupation']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Areas Of Occupation id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $areasOfOccupation = $this->AreasOfOccupation->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $areasOfOccupation = $this->AreasOfOccupation->patchEntity($areasOfOccupation, $this->request->data);
            if ($this->AreasOfOccupation->save($areasOfOccupation)) {
                $this->Flash->success(__('The areas of occupation has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The areas of occupation could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('areasOfOccupation'));
        $this->set('_serialize', ['areasOfOccupation']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Areas Of Occupation id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $areasOfOccupation = $this->AreasOfOccupation->get($id);
        if ($this->AreasOfOccupation->delete($areasOfOccupation)) {
            $this->Flash->success(__('The areas of occupation has been deleted.'));
        } else {
            $this->Flash->error(__('The areas of occupation could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
