<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * SupportiveMeasures Controller
 *
 * @property \App\Model\Table\SupportiveMeasuresTable $SupportiveMeasures
 */
class SupportiveMeasuresController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Medidas de Suporte e Procedimentos');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'SupportiveMeasures', $action);

        //return parent::isAuthorized($user);
    }
    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $supportiveMeasures = $this->paginate($this->SupportiveMeasures);

        $this->set(compact('supportiveMeasures'));
        $this->set('_serialize', ['supportiveMeasures']);
    }

    /**
     * View method
     *
     * @param string|null $id Supportive Measure id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $supportiveMeasure = $this->SupportiveMeasures->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('supportiveMeasure', $supportiveMeasure);
        $this->set('_serialize', ['supportiveMeasure']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $supportiveMeasure = $this->SupportiveMeasures->newEntity();
        if ($this->request->is('post')) {
            $supportiveMeasure = $this->SupportiveMeasures->patchEntity($supportiveMeasure, $this->request->data);
            if ($this->SupportiveMeasures->save($supportiveMeasure)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->SupportiveMeasures->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('supportiveMeasure', 'hospitalizations'));
        $this->set('_serialize', ['supportiveMeasure']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Supportive Measure id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $supportiveMeasure = $this->SupportiveMeasures->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $supportiveMeasure = $this->SupportiveMeasures->patchEntity($supportiveMeasure, $this->request->data);
            if ($this->SupportiveMeasures->save($supportiveMeasure)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->SupportiveMeasures->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('supportiveMeasure', 'hospitalizations'));
        $this->set('_serialize', ['supportiveMeasure']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Supportive Measure id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $supportiveMeasure = $this->SupportiveMeasures->get($id);
        if ($this->SupportiveMeasures->delete($supportiveMeasure)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
