<?php
namespace App\Model\Table;

use App\Model\Entity\MedicalCare;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * MedicalCares Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\HasMany $Diagnostics
 * @property \Cake\ORM\Association\HasMany $MedicationReconciliations
 */
class MedicalCaresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('medical_cares');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
            'joinType' => 'INNER'
        ]);
        $this->hasMany('Diagnostics', [
            'foreignKey' => 'medical_care_id'
        ]);
        $this->hasMany('MedicationReconciliations', [
            'foreignKey' => 'medical_care_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('origin');

        $validator
            ->allowEmpty('register_number');

        $validator
            ->allowEmpty('allergy');

        $validator
            ->allowEmpty('hda');

        $validator
            ->allowEmpty('hpp');

        $validator
            ->allowEmpty('clinical_examination');

        $validator
            ->allowEmpty('pa');

        $validator
            ->allowEmpty('fc');

        $validator
            ->allowEmpty('spo2');

        $validator
            ->allowEmpty('fr');

        $validator
            ->allowEmpty('temp');

        $validator
            ->allowEmpty('glicemia');

        $validator
            ->allowEmpty('laboratory_examination');

        $validator
            ->allowEmpty('chest_tomography');

        $validator
            ->allowEmpty('tomography');

        $validator
            ->allowEmpty('noradrenalina');

        $validator
            ->allowEmpty('vasopressina');

        $validator
            ->allowEmpty('dobutamina');

        $validator
            ->allowEmpty('glasgow');

        $validator
            ->allowEmpty('nipride');

        $validator
            ->allowEmpty('tridi');

        $validator
            ->allowEmpty('ancoron');

        $validator
            ->allowEmpty('pcr_previa');

        $validator
            ->allowEmpty('midazolam');

        $validator
            ->allowEmpty('fentanil');

        $validator
            ->allowEmpty('insulina');

        $validator
            ->allowEmpty('dexmedetomidina');

        $validator
            ->allowEmpty('morfina');

        $validator
            ->allowEmpty('reavaluation_need');

        $validator
            ->allowEmpty('diagnostic_impression');

        $validator
            ->allowEmpty('medical_carescol');

        $validator
            ->allowEmpty('conduct');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        return $rules;
    }
}
