<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Responsible']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Patients']), ['controller' => 'Patients', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Patient']), ['controller' => 'Patients', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Telephones']), ['controller' => 'Telephones', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Telephone']), ['controller' => 'Telephones', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="responsibles index col-md-10 columns content">
    <h3>Responsibles</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('name') ?></th>
                <th><?= $this->Paginator->sort('street') ?></th>
                <th><?= $this->Paginator->sort('country') ?></th>
                <th><?= $this->Paginator->sort('district') ?></th>
                <th><?= $this->Paginator->sort('house_number') ?></th>
                <th><?= $this->Paginator->sort('cep') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($responsibles as $responsible): ?>
            <tr>
                <td><?= $this->Number->format($responsible->id) ?></td>
                <td><?= h($responsible->name) ?></td>
                <td><?= h($responsible->street) ?></td>
                <td><?= h($responsible->country) ?></td>
                <td><?= h($responsible->district) ?></td>
                <td><?= h($responsible->house_number) ?></td>
                <td><?= h($responsible->cep) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $responsible->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $responsible->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $responsible->id], ['confirm' => __('Are you sure you want to delete # {0}?', $responsible->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>