<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * ApacheIiScores Controller
 *
 * @property \App\Model\Table\ApacheIiScoresTable $ApacheIiScores
 */
class RelatoriosController extends AppController
{

    public function initialize()
    {
        parent::initialize();

        $this->loadComponent('RequestHandler');

        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Relatórios');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Relatorios', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $hospitalizations_id = $this->request->session()->read('selected-hospitalization');

        // $this->paginate = [
        //     'contain' => ['Hospitalizations'],
        // ];
        $this->paginate = [
            'contain'    => ['NasScores', 'ApacheIiScores', 'PreDeliricScores', 'SnapIiScores', 'SapsIiiScores', 'SofaEscores', 'CribScores'],
            'conditions' => ['Hospitalizations.id =' => $hospitalizations_id],

        ];
        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $scores                 = $this->paginate($hospitalizations_table);

        //$apacheIiScores = $this->paginate($this->ApacheIiScores);

        $this->set(compact('scores'));
        $this->set('_serialize', ['scores']);
    }

    public function dashboard()
    {

    }

    public function view($id = null)
    {
        $patient_table = TableRegistry::get('Patients');
        $patient       = $patient_table->get($id);
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Patient' . $id,
            ],
        ]);
        $this->set('patient', $patient);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $apacheIiScore = $this->ApacheIiScores->newEntity();
        if ($this->request->is('post')) {
            $apacheIiScore = $this->ApacheIiScores->patchEntity($apacheIiScore, $this->request->data);
            if ($this->ApacheIiScores->save($apacheIiScore)) {
                $this->Flash->success(__('O registro foi salvo..'));
                return $this->redirect(['action' => 'index']);
            } else {
                Log::write('debug', $apacheIiScore);
                Log::write('debug', $apacheIiScore->errors());
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->ApacheIiScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('apacheIiScore', 'hospitalizations'));
        $this->set('_serialize', ['apacheIiScore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Apache Ii Score id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $apacheIiScore = $this->ApacheIiScores->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $apacheIiScore = $this->ApacheIiScores->patchEntity($apacheIiScore, $this->request->data);
            if ($this->ApacheIiScores->save($apacheIiScore)) {
                $this->Flash->success(__('O registro foi salvo..'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->ApacheIiScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('apacheIiScore', 'hospitalizations'));
        $this->set('_serialize', ['apacheIiScore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Apache Ii Score id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $apacheIiScore = $this->ApacheIiScores->get($id);
        if ($this->ApacheIiScores->delete($apacheIiScore)) {
            $this->Flash->success(__('O registro foi deletado'));
        } else {
            $this->Flash->error(__('O registro não foi deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }

    public function nutritionalAssessments()
    {
        //$arr = [];
        $arr = [
            'cirurgica' => ['media_indice_nutricional' => 0, 'nutrition_evolution' => 0],
            'clinica'   => ['nutrition_evolution' => 0, 'media_indice_nutricional' => 0],
            'geral'     => ['nutrition_evolution' => 0, 'media_indice_nutricional' => 0],
        ];

        $hospital_ids = [];
        $session      = $this->request->session();
        $unit_id      = $session->read('selected-unit');
        $cont         = 0;

        $evolution = [
            'cirurgica' => [],
            'geral'     => [],
            'clinica'   => [],
        ];
        $evo = [
            'cirurgica' => [],
            'geral'     => [],
            'clinica'   => [],
        ];
        $nutrition = [];

        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $nutrition_table        = TableRegistry::get('NutritionalAssessments');

        $hospital_result = $hospitalizations_table
            ->find()
            // ->select(['id'])
            ->where(['Hospitalizations.unit_id =' => $unit_id])
            ->toArray()
        ;

        //pega o id das internações separando por tipo
        foreach ($hospital_result as $key => $value) {
            if ($value['type'] == "Clínica") {
                $hospital_ids['clinica'][] = $value['id'];
            }

            if ($value['type'] == "Cirúrgica") {
                $hospital_ids['cirurgica'][] = $value['id'];
            }
            $hospital_ids['geral'][] = $value['id'];
        }

        //cada tipo de internação(clinica, cirurgica)
        foreach ($hospital_ids as $type => $typeArr) {
            $cont             = 0;
            $nutrition[$type] = $nutrition_table
                ->find()
                ->where(['NutritionalAssessments.hospitalization_id IN' => $hospital_ids[$type]])
                ->order(['NutritionalAssessments.created' => 'DESC'])
                ->toArray()
            ;

            foreach ($nutrition[$type] as $key => $value) {
                $cont++;
                $arr[$type]['media_indice_nutricional'] += $value['nutric_score'];
                //array_push($arr, $value);
                //$arr[$type] = $value;

                if ($value['nutric_score'] == 1) {
                    $evolution[$type] = $value['hospitalization_id'];
                }
            }

            //checa se o infeliz evoluiu no quadro de nutric_score partindo do número 1
            foreach ($nutrition[$type] as $key => $value) {
                //como a função in_array não aceita arrays multidimensionais criei um
                //array para receber o indice do array multidimensional
                $dummyArrEvolution[] = $evolution[$type];
                $dummyArrEvo[]       = $evo[$type];

                if (
                    (in_array($value['hospitalization_id'], $dummyArrEvo) == false)
                    && (in_array($value['hospitalization_id'], $dummyArrEvolution))
                ) {

                    if ($value['nutric_score'] > 1) {
                        $arr[$type]['nutrition_evolution']++;
                        $evo[$type][] = $value['hospitalization_id'];
                    }
                }
            }

            //gera a media do indice(total / quantidade)
            $arr[$type]['media_indice_nutricional'] = $arr[$type]['media_indice_nutricional'] / $cont;
        }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório de Nutrição',
            ],
        ]);

        $this->set('nutrition', $arr);
    }

    public function bundleVesicalCateter()
    {

        $hospital_ids = [];
        $session      = $this->request->session();
        $unit_id      = $session->read('selected-unit');
        $cont         = 0;

        // $evolution = [
        //     'cirurgica' => [],
        //     'geral'     => [],
        //     'clinica'   => [],
        // ];
        // $evo = [
        //     'cirurgica' => [],
        //     'geral'     => [],
        //     'clinica'   => [],
        // ];
        // $nutrition = [];

        // $hospitalizations_table = TableRegistry::get('Hospitalizations');
        // $nutrition_table        = TableRegistry::get('NutritionalAssessments');

        // $hospital_result = $hospitalizations_table
        //     ->find()
        //     // ->select(['id'])
        //     ->where(['Hospitalizations.unit_id =' => $unit_id])
        //     ->toArray()
        // ;

        // //pega o id das internações separando por tipo
        // foreach ($hospital_result as $key => $value) {
        //     if ($value['type'] == "Clínica") {
        //         $hospital_ids['clinica'][] = $value['id'];
        //     }

        //     if ($value['type'] == "Cirúrgica") {
        //         $hospital_ids['cirurgica'][] = $value['id'];
        //     }
        //     $hospital_ids['geral'][] = $value['id'];
        // }

        // //cada tipo de internação(clinica, cirurgica)
        // foreach ($hospital_ids as $type => $typeArr) {
        //     $cont             = 0;
        //     $nutrition[$type] = $nutrition_table
        //         ->find()
        //         ->where(['NutritionalAssessments.hospitalization_id IN' => $hospital_ids[$type]])
        //         ->order(['NutritionalAssessments.created' => 'DESC'])
        //         ->toArray()
        //     ;

        //     foreach ($nutrition[$type] as $key => $value) {
        //         $cont++;
        //         $arr[$type]['media_indice_nutricional'] += $value['nutric_score'];
        //         //array_push($arr, $value);
        //         //$arr[$type] = $value;

        //         if ($value['nutric_score'] == 1) {
        //             $evolution[$type] = $value['hospitalization_id'];
        //         }
        //     }

        //     //checa se o infeliz evoluiu no quadro de nutric_score partindo do número 1
        //     foreach ($nutrition[$type] as $key => $value) {
        //         //como a função in_array não aceita arrays multidimensionais criei um
        //         //array para receber o indice do array multidimensional
        //         $dummyArrEvolution[] = $evolution[$type];
        //         $dummyArrEvo[]       = $evo[$type];

        //         if (
        //             (in_array($value['hospitalization_id'], $dummyArrEvo) == false)
        //             && (in_array($value['hospitalization_id'], $dummyArrEvolution))
        //         ) {

        //             if ($value['nutric_score'] > 1) {
        //                 $arr[$type]['nutrition_evolution']++;
        //                 $evo[$type][] = $value['hospitalization_id'];
        //             }
        //         }
        //     }

        //     //gera a media do indice(total / quantidade)
        //     $arr[$type]['media_indice_nutricional'] = $arr[$type]['media_indice_nutricional'] / $cont;
        // }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename'    => 'Relatório de cateter vesical',
            ],
        ]);

        $this->set('nutrition', 'arr');
    }
}
