<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * PreAnestheticVisits Controller
 *
 * @property \App\Model\Table\PreAnestheticVisitsTable $PreAnestheticVisits
 */
class PreAnestheticVisitsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Visita Anestésica');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selectedted-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'SofaEscores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $preAnestheticVisits = $this->paginate($this->PreAnestheticVisits);

        $this->set(compact('preAnestheticVisits'));
        $this->set('_serialize', ['preAnestheticVisits']);
    }

    /**
     * View method
     *
     * @param string|null $id Pre Anesthetic Visit id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $preAnestheticVisit = $this->PreAnestheticVisits->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('preAnestheticVisit', $preAnestheticVisit);
        $this->set('_serialize', ['preAnestheticVisit']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $preAnestheticVisit = $this->PreAnestheticVisits->newEntity();
        if ($this->request->is('post')) {
            $preAnestheticVisit = $this->PreAnestheticVisits->patchEntity($preAnestheticVisit, $this->request->data);
            if ($this->PreAnestheticVisits->save($preAnestheticVisit)) {
                $this->Flash->success(__('The pre anesthetic visit has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The pre anesthetic visit could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->PreAnestheticVisits->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('preAnestheticVisit', 'hospitalizations'));
        $this->set('_serialize', ['preAnestheticVisit']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Pre Anesthetic Visit id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $preAnestheticVisit = $this->PreAnestheticVisits->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $preAnestheticVisit = $this->PreAnestheticVisits->patchEntity($preAnestheticVisit, $this->request->data);
            if ($this->PreAnestheticVisits->save($preAnestheticVisit)) {
                $this->Flash->success(__('The pre anesthetic visit has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The pre anesthetic visit could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->PreAnestheticVisits->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('preAnestheticVisit', 'hospitalizations'));
        $this->set('_serialize', ['preAnestheticVisit']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Pre Anesthetic Visit id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $preAnestheticVisit = $this->PreAnestheticVisits->get($id);
        if ($this->PreAnestheticVisits->delete($preAnestheticVisit)) {
            $this->Flash->success(__('The pre anesthetic visit has been deleted.'));
        } else {
            $this->Flash->error(__('The pre anesthetic visit could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
