<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * VentilatoryCarePlans Controller
 *
 * @property \App\Model\Table\VentilatoryCarePlansTable $VentilatoryCarePlans
 */
class VentilatoryCarePlansController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Plano Ventilatório');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $ventilatoryCarePlans = $this->paginate($this->VentilatoryCarePlans);

        $this->set(compact('ventilatoryCarePlans'));
        $this->set('_serialize', ['ventilatoryCarePlans']);
    }

    /**
     * View method
     *
     * @param string|null $id Ventilatory Care Plan id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $ventilatoryCarePlan = $this->VentilatoryCarePlans->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('ventilatoryCarePlan', $ventilatoryCarePlan);
        $this->set('_serialize', ['ventilatoryCarePlan']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $ventilatoryCarePlan = $this->VentilatoryCarePlans->newEntity();
        if ($this->request->is('post')) {
            $ventilatoryCarePlan = $this->VentilatoryCarePlans->patchEntity($ventilatoryCarePlan, $this->request->data);
            if ($this->VentilatoryCarePlans->save($ventilatoryCarePlan)) {
                $this->Flash->success(__('The ventilatory care plan has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The ventilatory care plan could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->VentilatoryCarePlans->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('ventilatoryCarePlan', 'hospitalizations'));
        $this->set('_serialize', ['ventilatoryCarePlan']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Ventilatory Care Plan id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $ventilatoryCarePlan = $this->VentilatoryCarePlans->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $ventilatoryCarePlan = $this->VentilatoryCarePlans->patchEntity($ventilatoryCarePlan, $this->request->data);
            if ($this->VentilatoryCarePlans->save($ventilatoryCarePlan)) {
                $this->Flash->success(__('The ventilatory care plan has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The ventilatory care plan could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->VentilatoryCarePlans->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('ventilatoryCarePlan', 'hospitalizations'));
        $this->set('_serialize', ['ventilatoryCarePlan']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Ventilatory Care Plan id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $ventilatoryCarePlan = $this->VentilatoryCarePlans->get($id);
        if ($this->VentilatoryCarePlans->delete($ventilatoryCarePlan)) {
            $this->Flash->success(__('The ventilatory care plan has been deleted.'));
        } else {
            $this->Flash->error(__('The ventilatory care plan could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
