<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * CardiacSurgeryChecklist Entity.
 *
 * @property int $id
 * @property bool $as_informacoes_do_paciente_foram_confirmadas
 * @property bool $o_consentimento_cirurgico_anestesico_foi_assinado
 * @property bool $visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel
 * @property bool $o_checklist_da_anestesia_foi_executado
 * @property bool $a_ficha_anestesica_esta_completa
 * @property bool $os_recursos_humanos_estao_disponiveis
 * @property bool $os_equipamentos_foram_verificados
 * @property bool $monitorizacao_standard_colocada_e_funcionante
 * @property bool $acesso_venoso_adequado
 * @property bool $alguma_alergia_conhecida
 * @property bool $via_aerea_dificil_risco_de_aspiracao
 * @property bool $flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo
 * @property bool $nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado
 * @property bool $cirurgiao_anestesista_e_enfermeiro_confirmaram
 * @property bool $procedimento_cirurgico_realizado
 * @property bool $contagem_correta_de_compressas
 * @property bool $pecas_anatomicas_e_produtos
 * @property bool $necessidades_pos_operatorias_revistas
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 */
class CardiacSurgeryChecklist extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
