<?php
    $default_units_nav_bar = ROOT.DS.'src'.DS.'Template'.DS.'Element'.DS.'units-nav-bar.ctp';
    
    if (file_exists($default_units_nav_bar)) 
    {
        ob_start();
        include $default_units_nav_bar;
        echo ob_get_clean();
    }
    else 
    {
        echo $this->element('units-nav-bar');
    }
?>
<?php $this->assign('title', $title); ?>

<div class="healthInsurancePlans view col-lg-10 col-md-9">
    <h3><?= h($healthInsurancePlan->name) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Name</th>
            <td><?= h($healthInsurancePlan->name) ?></td>
        </tr>
        <tr>
            <th>Type Of Coverage</th>
            <td><?= h($healthInsurancePlan->type_of_coverage) ?></td>
        </tr>
        <tr>
            <th>Scope Of Coverage</th>
            <td><?= h($healthInsurancePlan->scope_of_coverage) ?></td>
        </tr>
        <tr>
            <th>Unit</th>
            <td><?= $healthInsurancePlan->has('unit') ? $this->Html->link($healthInsurancePlan->unit->name, ['controller' => 'Units', 'action' => 'view', $healthInsurancePlan->unit->id]) : '' ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($healthInsurancePlan->id) ?></td>
        </tr>
        <tr>
            <th>Is Active</th>
            <td><?= $healthInsurancePlan->is_active ? __('Sim') : __('Não'); ?></td>
         </tr>
    </table>
</div>
