<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * ProfessionalsSpecialties Controller
 *
 * @property \App\Model\Table\ProfessionalsSpecialtiesTable $ProfessionalsSpecialties
 */
class ProfessionalsSpecialtiesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Professionals', 'Specialties']
        ];
        $professionalsSpecialties = $this->paginate($this->ProfessionalsSpecialties);

        $this->set(compact('professionalsSpecialties'));
        $this->set('_serialize', ['professionalsSpecialties']);
    }

    /**
     * View method
     *
     * @param string|null $id Professionals Specialty id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $professionalsSpecialty = $this->ProfessionalsSpecialties->get($id, [
            'contain' => ['Professionals', 'Specialties']
        ]);

        $this->set('professionalsSpecialty', $professionalsSpecialty);
        $this->set('_serialize', ['professionalsSpecialty']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $professionalsSpecialty = $this->ProfessionalsSpecialties->newEntity();
        if ($this->request->is('post')) {
            $professionalsSpecialty = $this->ProfessionalsSpecialties->patchEntity($professionalsSpecialty, $this->request->data);
            if ($this->ProfessionalsSpecialties->save($professionalsSpecialty)) {
                $this->Flash->success(__('The professionals specialty has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The professionals specialty could not be saved. Please, try again.'));
            }
        }
        $professionals = $this->ProfessionalsSpecialties->Professionals->find('list', ['limit' => 200]);
        $specialties = $this->ProfessionalsSpecialties->Specialties->find('list', ['limit' => 200]);
        $this->set(compact('professionalsSpecialty', 'professionals', 'specialties'));
        $this->set('_serialize', ['professionalsSpecialty']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Professionals Specialty id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $professionalsSpecialty = $this->ProfessionalsSpecialties->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $professionalsSpecialty = $this->ProfessionalsSpecialties->patchEntity($professionalsSpecialty, $this->request->data);
            if ($this->ProfessionalsSpecialties->save($professionalsSpecialty)) {
                $this->Flash->success(__('The professionals specialty has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The professionals specialty could not be saved. Please, try again.'));
            }
        }
        $professionals = $this->ProfessionalsSpecialties->Professionals->find('list', ['limit' => 200]);
        $specialties = $this->ProfessionalsSpecialties->Specialties->find('list', ['limit' => 200]);
        $this->set(compact('professionalsSpecialty', 'professionals', 'specialties'));
        $this->set('_serialize', ['professionalsSpecialty']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Professionals Specialty id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $professionalsSpecialty = $this->ProfessionalsSpecialties->get($id);
        if ($this->ProfessionalsSpecialties->delete($professionalsSpecialty)) {
            $this->Flash->success(__('The professionals specialty has been deleted.'));
        } else {
            $this->Flash->error(__('The professionals specialty could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
