<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Responsibles Controller
 *
 * @property \App\Model\Table\ResponsiblesTable $Responsibles
 */
class ResponsiblesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Patients']
        ];
        $responsibles = $this->paginate($this->Responsibles);

        $this->set(compact('responsibles'));
        $this->set('_serialize', ['responsibles']);
    }

    /**
     * View method
     *
     * @param string|null $id Responsible id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $responsible = $this->Responsibles->get($id, [
            'contain' => ['Patients', 'Telephones']
        ]);

        $this->set('responsible', $responsible);
        $this->set('_serialize', ['responsible']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $responsible = $this->Responsibles->newEntity();
        if ($this->request->is('post')) {
            $responsible = $this->Responsibles->patchEntity($responsible, $this->request->data);
            if ($this->Responsibles->save($responsible)) {
                $this->Flash->success(__('The responsible has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The responsible could not be saved. Please, try again.'));
            }
        }
        $patients = $this->Responsibles->Patients->find('list', ['limit' => 200]);
        $telephones = $this->Responsibles->Telephones->find('list', ['limit' => 200]);
        $this->set(compact('responsible', 'patients', 'telephones'));
        $this->set('_serialize', ['responsible']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Responsible id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $responsible = $this->Responsibles->get($id, [
            'contain' => ['Telephones']
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $responsible = $this->Responsibles->patchEntity($responsible, $this->request->data);
            if ($this->Responsibles->save($responsible)) {
                $this->Flash->success(__('The responsible has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The responsible could not be saved. Please, try again.'));
            }
        }
        $patients = $this->Responsibles->Patients->find('list', ['limit' => 200]);
        $telephones = $this->Responsibles->Telephones->find('list', ['limit' => 200]);
        $this->set(compact('responsible', 'patients', 'telephones'));
        $this->set('_serialize', ['responsible']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Responsible id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $responsible = $this->Responsibles->get($id);
        if ($this->Responsibles->delete($responsible)) {
            $this->Flash->success(__('The responsible has been deleted.'));
        } else {
            $this->Flash->error(__('The responsible could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
