<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Medical Care']), ['action' => 'edit', $medicalCare->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Medical Care']), ['action' => 'delete', $medicalCare->id], ['confirm' => __('Are you sure you want to delete # {0}?', $medicalCare->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Medical Cares']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Care']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Screenings']), ['controller' => 'Screenings', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Screening']), ['controller' => 'Screenings', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Diagnostics']), ['controller' => 'Diagnostics', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Diagnostic']), ['controller' => 'Diagnostics', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Medication Reconciliations']), ['controller' => 'MedicationReconciliations', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Medication Reconciliation']), ['controller' => 'MedicationReconciliations', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="medicalCares view col-lg-10 col-md-9">
    <h3><?= h($medicalCare->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Origin</th>
            <td><?= h($medicalCare->origin) ?></td>
        </tr>
        <tr>
            <th>Register Number</th>
            <td><?= h($medicalCare->register_number) ?></td>
        </tr>
        <tr>
            <th>Allergy</th>
            <td><?= h($medicalCare->allergy) ?></td>
        </tr>
        <tr>
            <th>Hda</th>
            <td><?= h($medicalCare->hda) ?></td>
        </tr>
        <tr>
            <th>Hpp</th>
            <td><?= h($medicalCare->hpp) ?></td>
        </tr>
        <tr>
            <th>Clinical Examination</th>
            <td><?= h($medicalCare->clinical_examination) ?></td>
        </tr>
        <tr>
            <th>Pa</th>
            <td><?= h($medicalCare->pa) ?></td>
        </tr>
        <tr>
            <th>Fc</th>
            <td><?= h($medicalCare->fc) ?></td>
        </tr>
        <tr>
            <th>Spo2</th>
            <td><?= h($medicalCare->spo2) ?></td>
        </tr>
        <tr>
            <th>Fr</th>
            <td><?= h($medicalCare->fr) ?></td>
        </tr>
        <tr>
            <th>Temp</th>
            <td><?= h($medicalCare->temp) ?></td>
        </tr>
        <tr>
            <th>Glicemia</th>
            <td><?= h($medicalCare->glicemia) ?></td>
        </tr>
        <tr>
            <th>Laboratory Examination</th>
            <td><?= h($medicalCare->laboratory_examination) ?></td>
        </tr>
        <tr>
            <th>Chest Tomography</th>
            <td><?= h($medicalCare->chest_tomography) ?></td>
        </tr>
        <tr>
            <th>Tomography</th>
            <td><?= h($medicalCare->tomography) ?></td>
        </tr>
        <tr>
            <th>Noradrenalina</th>
            <td><?= h($medicalCare->noradrenalina) ?></td>
        </tr>
        <tr>
            <th>Vasopressina</th>
            <td><?= h($medicalCare->vasopressina) ?></td>
        </tr>
        <tr>
            <th>Dobutamina</th>
            <td><?= h($medicalCare->dobutamina) ?></td>
        </tr>
        <tr>
            <th>Glasgow</th>
            <td><?= h($medicalCare->glasgow) ?></td>
        </tr>
        <tr>
            <th>Nipride</th>
            <td><?= h($medicalCare->nipride) ?></td>
        </tr>
        <tr>
            <th>Tridi</th>
            <td><?= h($medicalCare->tridi) ?></td>
        </tr>
        <tr>
            <th>Ancoron</th>
            <td><?= h($medicalCare->ancoron) ?></td>
        </tr>
        <tr>
            <th>Pcr Previa</th>
            <td><?= h($medicalCare->pcr_previa) ?></td>
        </tr>
        <tr>
            <th>Midazolam</th>
            <td><?= h($medicalCare->midazolam) ?></td>
        </tr>
        <tr>
            <th>Fentanil</th>
            <td><?= h($medicalCare->fentanil) ?></td>
        </tr>
        <tr>
            <th>Insulina</th>
            <td><?= h($medicalCare->insulina) ?></td>
        </tr>
        <tr>
            <th>Dexmedetomidina</th>
            <td><?= h($medicalCare->dexmedetomidina) ?></td>
        </tr>
        <tr>
            <th>Morfina</th>
            <td><?= h($medicalCare->morfina) ?></td>
        </tr>
        <tr>
            <th>Reavaluation Need</th>
            <td><?= h($medicalCare->reavaluation_need) ?></td>
        </tr>
        <tr>
            <th>Diagnostic Impression</th>
            <td><?= h($medicalCare->diagnostic_impression) ?></td>
        </tr>
        <tr>
            <th>Medical Carescol</th>
            <td><?= h($medicalCare->medical_carescol) ?></td>
        </tr>
        <tr>
            <th>Conduct</th>
            <td><?= h($medicalCare->conduct) ?></td>
        </tr>
        <tr>
            <th>Screening</th>
            <td><?= $medicalCare->has('screening') ? $this->Html->link($medicalCare->screening->id, ['controller' => 'Screenings', 'action' => 'view', $medicalCare->screening->id]) : '' ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($medicalCare->id) ?></td>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($medicalCare->created) ?></tr>
        </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Diagnostics']) ?></h4>
        <?php if (!empty($medicalCare->diagnostics)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Origin</th>
                <th>Created</th>
                <th>Modified</th>
                <th>Type</th>
                <th>Description</th>
                <th>Is Possible Diagnosis</th>
                <th>Patient Id</th>
                <th>Hospitalization Id</th>
                <th>Diagnostic Date</th>
                <th>Origin Id</th>
                <th>Medical Care Id</th>
                <th>Emergency Surgery</th>
                <th>Routine Surgery</th>
                <th>Clinic</th>
                <th>Grave Comorbidities</th>
                <th>Other Comorbidities</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($medicalCare->diagnostics as $diagnostics): ?>
            <tr>
                <td><?= h($diagnostics->id) ?></td>
                <td><?= h($diagnostics->origin) ?></td>
                <td><?= h($diagnostics->created) ?></td>
                <td><?= h($diagnostics->modified) ?></td>
                <td><?= h($diagnostics->type) ?></td>
                <td><?= h($diagnostics->description) ?></td>
                <td><?= h($diagnostics->is_possible_diagnosis) ?></td>
                <td><?= h($diagnostics->patient_id) ?></td>
                <td><?= h($diagnostics->hospitalization_id) ?></td>
                <td><?= h($diagnostics->diagnostic_date) ?></td>
                <td><?= h($diagnostics->origin_id) ?></td>
                <td><?= h($diagnostics->medical_care_id) ?></td>
                <td><?= h($diagnostics->emergency_surgery) ?></td>
                <td><?= h($diagnostics->routine_surgery) ?></td>
                <td><?= h($diagnostics->clinic) ?></td>
                <td><?= h($diagnostics->grave_comorbidities) ?></td>
                <td><?= h($diagnostics->other_comorbidities) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Diagnostics', 'action' => 'view', $diagnostics->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Diagnostics', 'action' => 'edit', $diagnostics->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Diagnostics', 'action' => 'delete', $diagnostics->id], ['confirm' => __('Are you sure you want to delete # {0}?', $diagnostics->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Medication Reconciliations']) ?></h4>
        <?php if (!empty($medicalCare->medication_reconciliations)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Name</th>
                <th>Description</th>
                <th>Created</th>
                <th>Medication Reconciliationscol</th>
                <th>Medical Care Id</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($medicalCare->medication_reconciliations as $medicationReconciliations): ?>
            <tr>
                <td><?= h($medicationReconciliations->id) ?></td>
                <td><?= h($medicationReconciliations->name) ?></td>
                <td><?= h($medicationReconciliations->description) ?></td>
                <td><?= h($medicationReconciliations->created) ?></td>
                <td><?= h($medicationReconciliations->medication_reconciliationscol) ?></td>
                <td><?= h($medicationReconciliations->medical_care_id) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'MedicationReconciliations', 'action' => 'view', $medicationReconciliations->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'MedicationReconciliations', 'action' => 'edit', $medicationReconciliations->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'MedicationReconciliations', 'action' => 'delete', $medicationReconciliations->id], ['confirm' => __('Are you sure you want to delete # {0}?', $medicationReconciliations->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
