<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Procedure']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Daily Safety Checklists']), ['controller' => 'DailySafetyChecklists', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Daily Safety Checklist']), ['controller' => 'DailySafetyChecklists', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="procedures index col-md-10 columns content">
    <h3>Procedures</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('description') ?></th>
                <th><?= $this->Paginator->sort('can_be_removed') ?></th>
                <th><?= $this->Paginator->sort('daily_safety_checklist_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($procedures as $procedure): ?>
            <tr>
                <td><?= $this->Number->format($procedure->id) ?></td>
                <td><?= h($procedure->description) ?></td>
                <td><?= h($procedure->can_be_removed) ?></td>
                <td><?= $procedure->has('daily_safety_checklist') ? $this->Html->link($procedure->daily_safety_checklist->id, ['controller' => 'DailySafetyChecklists', 'action' => 'view', $procedure->daily_safety_checklist->id]) : '' ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $procedure->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $procedure->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $procedure->id], ['confirm' => __('Are you sure you want to delete # {0}?', $procedure->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>