<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * ComorbiditiesHospitalizations Controller
 *
 * @property \App\Model\Table\ComorbiditiesHospitalizationsTable $ComorbiditiesHospitalizations
 */
class ComorbiditiesHospitalizationsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations', 'Comorbidities']
        ];
        $comorbiditiesHospitalizations = $this->paginate($this->ComorbiditiesHospitalizations);

        $this->set(compact('comorbiditiesHospitalizations'));
        $this->set('_serialize', ['comorbiditiesHospitalizations']);
    }

    /**
     * View method
     *
     * @param string|null $id Comorbidities Hospitalization id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $comorbiditiesHospitalization = $this->ComorbiditiesHospitalizations->get($id, [
            'contain' => ['Hospitalizations', 'Comorbidities']
        ]);

        $this->set('comorbiditiesHospitalization', $comorbiditiesHospitalization);
        $this->set('_serialize', ['comorbiditiesHospitalization']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $comorbiditiesHospitalization = $this->ComorbiditiesHospitalizations->newEntity();
        if ($this->request->is('post')) {
            $comorbiditiesHospitalization = $this->ComorbiditiesHospitalizations->patchEntity($comorbiditiesHospitalization, $this->request->data);
            if ($this->ComorbiditiesHospitalizations->save($comorbiditiesHospitalization)) {
                $this->Flash->success(__('The comorbidities hospitalization has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The comorbidities hospitalization could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->ComorbiditiesHospitalizations->Hospitalizations->find('list', ['limit' => 200]);
        $comorbidities = $this->ComorbiditiesHospitalizations->Comorbidities->find('list', ['limit' => 200]);
        $this->set(compact('comorbiditiesHospitalization', 'hospitalizations', 'comorbidities'));
        $this->set('_serialize', ['comorbiditiesHospitalization']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Comorbidities Hospitalization id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $comorbiditiesHospitalization = $this->ComorbiditiesHospitalizations->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $comorbiditiesHospitalization = $this->ComorbiditiesHospitalizations->patchEntity($comorbiditiesHospitalization, $this->request->data);
            if ($this->ComorbiditiesHospitalizations->save($comorbiditiesHospitalization)) {
                $this->Flash->success(__('The comorbidities hospitalization has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The comorbidities hospitalization could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->ComorbiditiesHospitalizations->Hospitalizations->find('list', ['limit' => 200]);
        $comorbidities = $this->ComorbiditiesHospitalizations->Comorbidities->find('list', ['limit' => 200]);
        $this->set(compact('comorbiditiesHospitalization', 'hospitalizations', 'comorbidities'));
        $this->set('_serialize', ['comorbiditiesHospitalization']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Comorbidities Hospitalization id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $comorbiditiesHospitalization = $this->ComorbiditiesHospitalizations->get($id);
        if ($this->ComorbiditiesHospitalizations->delete($comorbiditiesHospitalization)) {
            $this->Flash->success(__('The comorbidities hospitalization has been deleted.'));
        } else {
            $this->Flash->error(__('The comorbidities hospitalization could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
