<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Surgery Entity.
 *
 * @property int $id
 * @property string $nome
 * @property string $especialidade
 * @property bool $outra_especialidade_cirurgica_em_apoio
 * @property string $especialidade_cirurgica_auxiliar
 * @property string $porte_da_cirurgia
 * @property string $caracteristica_da_cirurgia
 * @property string $cirurgia_contaminada
 * @property bool $anestesia_adequada_foi_confirmada
 * @property \Cake\I18n\Time $data_da_solicitacao
 * @property \Cake\I18n\Time $data_da_cirurgia
 * @property \Cake\I18n\Time $data_da_liberacao
 * @property \Cake\I18n\Time $tempo_de_cirurgia_estimado
 * @property \Cake\I18n\Time $hora_da_cirurgia
 * @property bool $internacao_previa_a_cirurgia
 * @property bool $deseja_reservar_leito
 * @property int $total_dias_do_leito_reservado
 * @property bool $pos_operatorio_em_uti
 * @property bool $conversao_da_caracteristica_da_cirurgia
 * @property string $conversao_para
 * @property bool $adiar_cirurgia
 * @property \Cake\I18n\Time $aidar_cirurgia_para_data
 * @property \Cake\I18n\Time $aidar_cirurgia_para_hora
 * @property string $adiar_cirurgia_motivo
 * @property bool $suspender_cirurgia
 * @property \Cake\I18n\Time $suspender_cirurgia_para_data
 * @property \Cake\I18n\Time $suspender_cirurgia_para_hora
 * @property string $suspender_cirurgia_motiv
 * @property bool $cancelar_cirurgia
 * @property string $cancelar_cirurgia_motivo
 * @property bool $visita_pre_anestesica
 * @property \Cake\I18n\Time $visita_pre_anestesica_data
 * @property \Cake\I18n\Time $visita_pre_anestesica_hora
 * @property bool $entrada_na_sala_cirurgica
 * @property \Cake\I18n\Time $entrada_na_sala_cirurgica_data
 * @property \Cake\I18n\Time $entrada_na_sala_cirurgica_hora
 * @property bool $realizado_antibiotico_profilaxia
 * @property \Cake\I18n\Time $realizado_antibiotico_profilaxia_data
 * @property \Cake\I18n\Time $realizado_antibiotico_profilaxia_hora
 * @property \Cake\I18n\Time $inicio_da_anestesia_hora
 * @property \Cake\I18n\Time $termino_da_anestesia_hora
 * @property \Cake\I18n\Time $inicio_da_cirurgia_hora
 * @property \Cake\I18n\Time $termino_da_cirurgia_hora
 * @property bool $houve_mudanca_na_cirurgia
 * @property string $mudanca_na_cirurgia
 * @property bool $houve_mudanca_na_anestesia
 * @property string $mudanca_na_anestesia
 * @property string $houve_complicacao_durante_cirurgia
 * @property bool $uso_de_compressa_cirurgica
 * @property int $total_de_compressa_cirurgica_usada
 * @property bool $uso_de_pinca_extra
 * @property int $total_de_pinca_extra_usada
 * @property bool $uso_de_caixa_extra
 * @property int $total_de_caixa_extra
 * @property bool $encaminhado_para_setor_de_destino_programado
 * @property string $setor_nao_programado
 * @property string $encaminhado_para_setor_nao_programado_motivo
 * @property bool $houve_reabordagem_cirurgica
 * @property string $reabordagem_programada
 * @property bool $retirada_de_ortese_ou_protese
 * @property string $retirada_de_ortese_ou_protese_motivo
 * @property \Cake\I18n\Time $data_da_instalacao_ortese_ou_protese
 * @property \Cake\I18n\Time $created
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property \App\Model\Entity\Professional[] $professionals
 * @property \App\Model\Entity\SurgicalMaterial[] $surgical_materials
 * @property \App\Model\Entity\TypeOfAnesthesia[] $type_of_anesthesias
 */
class Surgery extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
