<?php    
    echo $this->element( 'internacao-menu' );
?>
<div class="cribScores form col-md-9 columns content">
    <?= $this->Form->create($cribScore) ?>
    <fieldset>
        
        <?php
        $peso_nascimento_opt = ['> 1.350' => '> 1.350', '851 - 1.350'=>'851 - 1.350', '701 - 850'=>'701 - 850', '<= 700'=> '<= 700'];

        $idade_gestacional_opt = ['> 24' => '> 24', '<= 24'=>'<= 24'];
        $malformacao_opt = ['Ausente' => 'Ausente', 'Sem risco de vida imediato'=>'Sem risco de Vida Imediato', 'Com risco de vida imediato'=>'Com Risco de Vida Imediato'];
        $be_max_opt = ['> -7,0' => '> -7,0', '-7,0 a -9,9'=>'-7,0 a -9,9', '-10,0 a -14,9'=>'-10,0 a -14,9', '<= -15,0'=>'<= -15,0'];
        $be_min_opt = ['<= 0,40' => '<= 0,40',' 0,41 - 0,60'=>' 0,41 - 0,60', '0,61 - 0,90'=>'0,61 - 0,90', '0,91 - 1,00'=> '0,91 - 1,00'];
        $be_max_opt = ['<= 0,40' => '<= 0,40',' 0,41 - 0,80'=>' 0,41 - 0,80', '0,81 - 0,90'=>'0,81 - 0,90', '0,91 - 1,00'=> '0,91 - 1,00'];

            echo $this->Form->input('peso_nascimento', ['class'=>'item1', 'empty'=>true,'options'=>$peso_nascimento_opt, 'label'=>['text'=>'Peso de Nascimento (g):', 'class'=>'form-input'] ]);

            echo $this->Form->input('idade_gestacional', ['class'=>'item2', 'empty'=>true,'options'=>$idade_gestacional_opt, 'label'=>['text'=>'Idade Gestacional:', 'class'=>'form-input'] ]);

            echo $this->Form->input('malfomacao_congenita', ['class'=>'item3', 'empty'=>true,'options'=>$malformacao_opt, 'label'=>['text'=>'Malformação Congênita:', 'class'=>'form-input'] ]);

            echo $this->Form->input('be_maximo_nas_primeiros_12h_de_vida', ['class'=>'item4', 'empty'=>true,'options'=>$be_max_opt, 'label'=>['text'=>'BE máximo nas primeiras 2h de vida (mmol/l):', 'class'=>'form-input'] ]);

            echo $this->Form->input('fio2_minima_apropriada_nas_primeiras_12h_de_vida', ['class'=>'item5','empty'=>true,'options'=>$be_min_opt, 'label'=>['text'=>'FiO2 mínima apropriada nas primeiras 12h de vida:', 'class'=>'form-input'] ]);

            echo $this->Form->input('fio2_maxima_apropriada_nas_primeiras_12h_de_vida', ['class'=>'item6', 'empty'=>true,'options'=>$be_max_opt, 'label'=>['text'=>'FiO2 máxima apropriada nas primeiras 12h de vida:', 'class'=>'form-input'] ]);
            echo $this->Form->input('data_realizacao', ['class'=>'date', 'type'=>'text','label'=>['text'=>'Data de Realização:', 'class'=>' form-input'],'empty' => true, 'default' => '']);
            
            echo $this->Form->input('pontuation', ['class'=>"hide", 'label'=>false, 'id'=>'pontuation-id']);
            echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id]);            
            
        ?>
        <h3 id="pontuation">Pontuação: </h3> 
    </fieldset>
    <?= $this->Form->button(__('salvar')) ?>
    <?= $this->Form->end() ?>
</div>


<script>
var pontuation = 0;

$('select').change(function(){
  calculatePt();
});
function calculatePt(elem, item)
{
    pontuation = 0;
  //console.log($(elem).val());

  $( "select" ).each(function( index ) 
  {
    console.log($(this).val());

      if ($( this ).hasClass( "item1" ))
      {
        switch($(this).val()) 
          {
            case '851 - 1.350':
                pontuation += 1;
                break;
            case '701 - 850':
                pontuation += 4;
                break;
            case '<= 700':
                pontuation += 7;
                break;
          }
      }
      else if ($( this ).hasClass( "item2" ))
      {
          switch($(this).val()) 
          {
            case '<= 24':
              pontuation += 1;
              break;
          }
      }
      else if ($( this ).hasClass( "item3" ))
      {
          switch($(this).val()) 
          {
             case 'Sem risco de vida imediato':
              pontuation += 1;
              break;   
            case 'Com risco de vida imediato':
              pontuation += 3;
              break;
          }
      }
      else if ($( this ).hasClass( "item4" ))
      {
          switch($(this).val()) 
          {
            case '-7,0  a -9,9':
              pontuation += 1;
              break;                                     
            case '-10,0 a -14,9':
              pontuation += 2;
              break;   
            case '<= -15,0':
              pontuation += 3;
              break;                                             
          }
      }
      else if ($( this ).hasClass( "item5" ))
      {
          switch($(this).val()) 
          {
             case '0,41 - 0,60':
              pontuation += 2;
              break;                                     
            case '0,61 - 0,90':
              pontuation += 3;
              break;          
            case '0,91 - 1,00':
              pontuation += 4;
              break; 
          }
      }
      else if ($( this ).hasClass( "item6" ))
      {
          switch($(this).val()) 
          {
            case '0,41 - 0,80':
              pontuation += 1;
              break;   
            case '0,81 - 0,90':
              pontuation += 3;
              break;                                     
            case '0,91 - 1,00':
              pontuation += 1;
              break; 
          }
      }
 });


  console.log("pontuation = "+pontuation);

  $('#pontuation-id').val(pontuation);
  $('#pontuation').text("Pontuação: "+ pontuation);
}
(function() {
   // your page initialization code here
   // the DOM will be available here

   var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>', 
    array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

   var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

   var link3 =' <?= $this->Html->link('Internação',['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var link4 =' <?= $this->Html->link('Escores',['controller' => 'ApacheIiScores', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= link4;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Escore Crib</a>';        
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>