<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * CardiacSurgeryChecklists Controller
 *
 * @property \App\Model\Table\CardiacSurgeryChecklistsTable $CardiacSurgeryChecklists
 */
class CardiacSurgeryChecklistsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations']
        ];
        $cardiacSurgeryChecklists = $this->paginate($this->CardiacSurgeryChecklists);

        $this->set(compact('cardiacSurgeryChecklists'));
        $this->set('_serialize', ['cardiacSurgeryChecklists']);
    }

    /**
     * View method
     *
     * @param string|null $id Cardiac Surgery Checklist id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->get($id, [
            'contain' => ['Hospitalizations']
        ]);

        $this->set('cardiacSurgeryChecklist', $cardiacSurgeryChecklist);
        $this->set('_serialize', ['cardiacSurgeryChecklist']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->newEntity();
        if ($this->request->is('post')) {
            $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->patchEntity($cardiacSurgeryChecklist, $this->request->data);
            if ($this->CardiacSurgeryChecklists->save($cardiacSurgeryChecklist)) {
                $this->Flash->success(__('The cardiac surgery checklist has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The cardiac surgery checklist could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->CardiacSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('cardiacSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['cardiacSurgeryChecklist']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Cardiac Surgery Checklist id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->patchEntity($cardiacSurgeryChecklist, $this->request->data);
            if ($this->CardiacSurgeryChecklists->save($cardiacSurgeryChecklist)) {
                $this->Flash->success(__('The cardiac surgery checklist has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The cardiac surgery checklist could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->CardiacSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('cardiacSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['cardiacSurgeryChecklist']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Cardiac Surgery Checklist id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->get($id);
        if ($this->CardiacSurgeryChecklists->delete($cardiacSurgeryChecklist)) {
            $this->Flash->success(__('The cardiac surgery checklist has been deleted.'));
        } else {
            $this->Flash->error(__('The cardiac surgery checklist could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
