<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Diagnostics Controller
 *
 * @property \App\Model\Table\DiagnosticsTable $Diagnostics
 */
class DiagnosticsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Patients', 'Hospitalizations', 'Origins', 'MedicalCares']
        ];
        $diagnostics = $this->paginate($this->Diagnostics);

        $this->set(compact('diagnostics'));
        $this->set('_serialize', ['diagnostics']);
    }

    /**
     * View method
     *
     * @param string|null $id Diagnostic id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $diagnostic = $this->Diagnostics->get($id, [
            'contain' => ['Patients', 'Hospitalizations', 'Origins', 'MedicalCares', 'Comorbidities', 'OtherComorbidities']
        ]);

        $this->set('diagnostic', $diagnostic);
        $this->set('_serialize', ['diagnostic']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $diagnostic = $this->Diagnostics->newEntity();
        if ($this->request->is('post')) {
            $diagnostic = $this->Diagnostics->patchEntity($diagnostic, $this->request->data);
            if ($this->Diagnostics->save($diagnostic)) {
                $this->Flash->success(__('The diagnostic has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The diagnostic could not be saved. Please, try again.'));
            }
        }
        $patients = $this->Diagnostics->Patients->find('list', ['limit' => 200]);
        $hospitalizations = $this->Diagnostics->Hospitalizations->find('list', ['limit' => 200]);
        $origins = $this->Diagnostics->Origins->find('list', ['limit' => 200]);
        $medicalCares = $this->Diagnostics->MedicalCares->find('list', ['limit' => 200]);
        $comorbidities = $this->Diagnostics->Comorbidities->find('list', ['limit' => 200]);
        $otherComorbidities = $this->Diagnostics->OtherComorbidities->find('list', ['limit' => 200]);
        $this->set(compact('diagnostic', 'patients', 'hospitalizations', 'origins', 'medicalCares', 'comorbidities', 'otherComorbidities'));
        $this->set('_serialize', ['diagnostic']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Diagnostic id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $diagnostic = $this->Diagnostics->get($id, [
            'contain' => ['Comorbidities', 'OtherComorbidities']
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $diagnostic = $this->Diagnostics->patchEntity($diagnostic, $this->request->data);
            if ($this->Diagnostics->save($diagnostic)) {
                $this->Flash->success(__('The diagnostic has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The diagnostic could not be saved. Please, try again.'));
            }
        }
        $patients = $this->Diagnostics->Patients->find('list', ['limit' => 200]);
        $hospitalizations = $this->Diagnostics->Hospitalizations->find('list', ['limit' => 200]);
        $origins = $this->Diagnostics->Origins->find('list', ['limit' => 200]);
        $medicalCares = $this->Diagnostics->MedicalCares->find('list', ['limit' => 200]);
        $comorbidities = $this->Diagnostics->Comorbidities->find('list', ['limit' => 200]);
        $otherComorbidities = $this->Diagnostics->OtherComorbidities->find('list', ['limit' => 200]);
        $this->set(compact('diagnostic', 'patients', 'hospitalizations', 'origins', 'medicalCares', 'comorbidities', 'otherComorbidities'));
        $this->set('_serialize', ['diagnostic']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Diagnostic id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $diagnostic = $this->Diagnostics->get($id);
        if ($this->Diagnostics->delete($diagnostic)) {
            $this->Flash->success(__('The diagnostic has been deleted.'));
        } else {
            $this->Flash->error(__('The diagnostic could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
