<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * SurgicalChecklists Controller
 *
 * @property \App\Model\Table\SurgicalChecklistsTable $SurgicalChecklists
 */
class SurgicalChecklistsController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('Upload');
        $this->set('title', 'Checklist');

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        $session   = $this->request->session();
        $unit_role = $session->read('selected-unit-role-name');

        if (isset($unit_role)) {
            return $this->Permission->hasPermission($unit_role, 'SurgicalChecklists', $action);
        } else {
            return $this->redirect(['controller' => 'users', 'action' => 'login']);
            //return  $this->Permission->hasPermission($user['role_name'], 'sectors', $action);
        }
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            //'contain' => ['Hospitalizations'],

        ];
        // $hospitalizations_id = $this->request->session()->read('selected-hospitalization');
        // $patient_id          = $this->request->session()->read('selected-pacient');

        // $dailysafetychecklists_table = TableRegistry::get('DailySafetyChecklists');

        // $dailysafetychecklists = $dailysafetychecklists_table
        //     ->find()
        //     ->where(['DailySafetyChecklists.hospitalization_id =' => $hospitalizations_id])
        //     ->toArray()
        // ;

        // $surgicalChecklists_teste = $this->SurgicalChecklists
        //     ->find()
        //     ->where(['SurgicalChecklists.hospitalization_id =' => $hospitalizations_id])
        //     ->toArray()
        // ;

        //$surgicalChecklists_teste = array_merge($surgicalChecklists_teste, $dailysafetychecklists);

        // $hospitalizations->innerJoinWith('DailySafetyChecklists')

        //     ->autoFields(true)
        //     ->toArray()
        // ;

        $surgicalChecklists = $this->paginate($this->SurgicalChecklists);
        //$surgicalChecklists = $this->paginate($this->SurgicalChecklists);
        //$this->paginate($surgicalChecklists_teste)

        $this->set(compact('surgicalChecklists'));
        $this->set('_serialize', ['surgicalChecklists']);
    }

    /**
     * View method
     *
     * @param string|null $id Surgical Checklist id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $surgicalChecklist = $this->SurgicalChecklists->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('surgicalChecklist', $surgicalChecklist);
        $this->set('_serialize', ['surgicalChecklist']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $session            = $this->request->session();
        $hospitalization_id = $session->read('selected-hospitalization');

        $surgicalChecklist = $this->SurgicalChecklists->newEntity();

        if ($this->request->is('post')) {
            $surgicalChecklist = $this->SurgicalChecklists->patchEntity($surgicalChecklist, $this->request->data);

            if ($this->SurgicalChecklists->save($surgicalChecklist)) {
                $this->Flash->success(__('O checklist foi salvo.'));
                return $this->redirect(['action' => 'index']);

            } else {
                $this->Flash->error(__('O checklist não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $this->set('hospitalization_id', $hospitalization_id);
        $hospitalizations = $this->SurgicalChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('surgicalChecklist', 'hospitalizations'));
        $this->set('_serialize', ['surgicalChecklist']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Surgical Checklist id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $surgicalChecklist = $this->SurgicalChecklists->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $surgicalChecklist = $this->SurgicalChecklists->patchEntity($surgicalChecklist, $this->request->data);
            if ($this->SurgicalChecklists->save($surgicalChecklist)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->SurgicalChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('surgicalChecklist', 'hospitalizations'));
        $this->set('_serialize', ['surgicalChecklist']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Surgical Checklist id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $surgicalChecklist = $this->SurgicalChecklists->get($id);
        if ($this->SurgicalChecklists->delete($surgicalChecklist)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
