<?php
namespace App\Model\Table;

use App\Model\Entity\DailySafetyChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * DailySafetyChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $Procedures
 */
class DailySafetyChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('daily_safety_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
        $this->hasMany('Procedures', [
            'foreignKey' => 'daily_safety_checklist_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('cabeceira_de_leito_elevado');

        $validator
            ->allowEmpty('prevenção_de_lesao_aguda_de_mucosa_gastrica');

        $validator
            ->allowEmpty('profilaxia_de_tev');

        $validator
            ->allowEmpty('suporte_nutricional');

        $validator
            ->boolean('protocolo_de_controle_glicemico')
            ->allowEmpty('protocolo_de_controle_glicemico');

        $validator
            ->allowEmpty('total_de_insulina_sub_cutanea_nas_24_horas');

        $validator
            ->boolean('fez_insulina_venosa')
            ->allowEmpty('fez_insulina_venosa');

        $validator
            ->allowEmpty('total_de_insulina_venosa_nas_24_horas');

        $validator
            ->allowEmpty('total_de_glicemias');

        $validator
            ->boolean('sedacao')
            ->allowEmpty('sedacao');

        $validator
            ->boolean('sob_analgesia')
            ->allowEmpty('sob_analgesia');

        $validator
            ->boolean('delirium')
            ->allowEmpty('delirium');

        $validator
            ->boolean('teve_dor_nas_ultimas_24_horas')
            ->allowEmpty('teve_dor_nas_ultimas_24_horas');

        $validator
            ->boolean('ventilacao_mecanica_invasiva')
            ->allowEmpty('ventilacao_mecanica_invasiva');

        $validator
            ->boolean('pa2_fio2_menor_que_300')
            ->allowEmpty('pa2_fio2_menor_que_300');

        $validator
            ->boolean('volume_corrente_menor_que_8')
            ->allowEmpty('volume_corrente_menor_que_8');

        $validator
            ->boolean('pressao_de_plato_menor_que_30')
            ->allowEmpty('pressao_de_plato_menor_que_30');

        $validator
            ->boolean('iniciar_desmane')
            ->allowEmpty('iniciar_desmane');

        $validator
            ->boolean('iniciar_peca_t')
            ->allowEmpty('iniciar_peca_t')
            // ->add('iniciar_peca_t', 'unique', ['rule' => 'validateUnique', 'provider' => 'table']);
        ;
        $validator
            ->boolean('cateter_venoso_central')
            ->allowEmpty('cateter_venoso_central');

        $validator
            ->boolean('cateter_arterial_can_be_removed')
            ->allowEmpty('cateter_arterial_can_be_removed');

        $validator
            ->boolean('cateter_vesical_de_demora')
            ->allowEmpty('cateter_vesical_de_demora');

        $validator
            ->boolean('cateter_vesical_de_demora_can_be_removed')
            ->allowEmpty('cateter_vesical_de_demora_can_be_removed');

        $validator
            ->boolean('antibioticos')
            ->allowEmpty('antibioticos');

        $validator
            ->boolean('antibioticos_can_be_removed')
            ->allowEmpty('antibioticos_can_be_removed');

        $validator
            ->boolean('corticoesteroides')
            ->allowEmpty('corticoesteroides');

        $validator
            ->boolean('corticoesteroides_can_be_removed')
            ->allowEmpty('corticoesteroides_can_be_removed');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        // $rules->add($rules->isUnique(['iniciar_peca_t']));
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
