<?php $this->assign('title', $title); ?>

<div class="units index col-md col-lg columns content">
    <h3>Unidades</h3>
    <br>   
    <?php 
    if ($isLogged['role_name'] == "Administrador")    
        echo $this->Html->link('Nova Unidade',
            ['controller' => 'Units', 'action' => 'add']
            , array('class' => 'link-bt'));  
    ?>
    <br><br>    

    <table class="table table-striped table-hover">
        <thead>
            <tr>     
                <th><?= $this->Paginator->sort('name', ['label'=>"Unidade"]) ?></th>
                <th><?= $this->Paginator->sort('group', ['label'=>'Grupo']) ?></th>                           
                <th><?= $this->Paginator->sort('email', array( 'label' => 'E-mail')) ?></th>
                <th><?= $this->Paginator->sort('telefone') ?></th>
                <th><?= $this->Paginator->sort('is_active', array('label'=>'Status')) ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($units as $unit): ?>
            <tr>        
                <td><?= h($unit->name) ?></td>  
                <td>
                    <?= $unit->has('group') ? $this->Html->link($unit->group->name, ['controller' => 'Groups', 'action' => 'view', $unit->group->id]) : '' ?>
                </td>                      
                <td><?= h($unit->email) ?></td>
                <td><?= h($unit->telephone) ?></td>
                <td>
                <?php  
                    echo h($unit->is_active)? "Ativo" : "Suspenso";
                ?>
                </td>
                <td class="actions" style="white-space:nowrap">
                    <?php //echo $this->Html->link(__('Ver'), ['action' => 'view', $unit->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Editar'), ['action' => 'edit', $unit->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Html->link(__('Usuários'), ['action' => 'list-users', $unit->id], ['class'=>'btn btn-warning btn-xs']) ?>
                    <?php ?>
                    <?php
                        if ( h($unit->is_active) )
                        {
                            echo $this->Form->postLink(__('Suspender'), ['action' => 'desactivate', $unit->id], ['confirm' => __('Tem certeza que deseja desativar # {0}?', $unit->id), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                        }     
                        else 
                        {
                           echo $this->Form->postLink(__('Ativar'), ['action' => 'activate', $unit->id], ['confirm' => __('Tem certeza que deseja ativar # {0}?', $unit->id), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                        }               
                         
                    ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
        </div>
    </center>
</div>
</div>