<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * CardiacSurgeryChecklists Controller
 *
 * @property \App\Model\Table\CardiacSurgeryChecklistsTable $CardiacSurgeryChecklists
 */
class CardiacSurgeryChecklistsController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Checklist');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'CardiacSurgeryChecklists', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $cardiacSurgeryChecklists = $this->paginate($this->CardiacSurgeryChecklists);

        $this->set(compact('cardiacSurgeryChecklists'));
        $this->set('_serialize', ['cardiacSurgeryChecklists']);
    }

    /**
     * View method
     *
     * @param string|null $id Cardiac Surgery Checklist id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('cardiacSurgeryChecklist', $cardiacSurgeryChecklist);
        $this->set('_serialize', ['cardiacSurgeryChecklist']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->newEntity();
        if ($this->request->is('post')) {
            $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->patchEntity($cardiacSurgeryChecklist, $this->request->data);
            if ($this->CardiacSurgeryChecklists->save($cardiacSurgeryChecklist)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'surgicalChecklists', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->CardiacSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('cardiacSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['cardiacSurgeryChecklist']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Cardiac Surgery Checklist id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->patchEntity($cardiacSurgeryChecklist, $this->request->data);
            if ($this->CardiacSurgeryChecklists->save($cardiacSurgeryChecklist)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'surgicalChecklists', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->CardiacSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('cardiacSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['cardiacSurgeryChecklist']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Cardiac Surgery Checklist id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $cardiacSurgeryChecklist = $this->CardiacSurgeryChecklists->get($id);
        if ($this->CardiacSurgeryChecklists->delete($cardiacSurgeryChecklist)) {
            $this->Flash->success(__('O registro foi salvo.'));
        } else {
            $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
        }
        return $this->redirect(['controller' => 'surgicalChecklists', 'action' => 'index']);
    }
}
