<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * CurbScores Controller
 *
 * @property \App\Model\Table\CurbScoresTable $CurbScores
 */
class CurbScoresController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations']
        ];
        $curbScores = $this->paginate($this->CurbScores);

        $this->set(compact('curbScores'));
        $this->set('_serialize', ['curbScores']);
    }

    /**
     * View method
     *
     * @param string|null $id Curb Score id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $curbScore = $this->CurbScores->get($id, [
            'contain' => ['Hospitalizations']
        ]);

        $this->set('curbScore', $curbScore);
        $this->set('_serialize', ['curbScore']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $curbScore = $this->CurbScores->newEntity();
        if ($this->request->is('post')) {
            $curbScore = $this->CurbScores->patchEntity($curbScore, $this->request->data);
            if ($this->CurbScores->save($curbScore)) {
                $this->Flash->success(__('The curb score has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The curb score could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->CurbScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('curbScore', 'hospitalizations'));
        $this->set('_serialize', ['curbScore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Curb Score id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $curbScore = $this->CurbScores->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $curbScore = $this->CurbScores->patchEntity($curbScore, $this->request->data);
            if ($this->CurbScores->save($curbScore)) {
                $this->Flash->success(__('The curb score has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The curb score could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->CurbScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('curbScore', 'hospitalizations'));
        $this->set('_serialize', ['curbScore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Curb Score id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $curbScore = $this->CurbScores->get($id);
        if ($this->CurbScores->delete($curbScore)) {
            $this->Flash->success(__('The curb score has been deleted.'));
        } else {
            $this->Flash->error(__('The curb score could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
