<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;
use Cake\ORM\TableRegistry; 
use Cake\Datasource\ConnectionManager;

/**
 * IndicatorsSectors Controller
 *
 * @property \App\Model\Table\IndicatorsSectorsTable $IndicatorsSectors
 */
class IndicatorsSectorsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Sectors']
        ];
        $indicatorsSectors = $this->paginate($this->IndicatorsSectors);

        $this->set(compact('indicatorsSectors'));
        $this->set('_serialize', ['indicatorsSectors']);
    }

    /**
     * View method
     *
     * @param string|null $id Indicators Sector id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $indicatorsSector = $this->IndicatorsSectors->get($id, [
            'contain' => ['Sectors']
        ]);

        $this->set('indicatorsSector', $indicatorsSector);
        $this->set('_serialize', ['indicatorsSector']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $indicatorsSector = $this->IndicatorsSectors->newEntity();
        if ($this->request->is('post')) {
            $indicatorsSector = $this->IndicatorsSectors->patchEntity($indicatorsSector, $this->request->data);
            if ($this->IndicatorsSectors->save($indicatorsSector)) {
                $this->Flash->success(__('The indicators sector has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The indicators sector could not be saved. Please, try again.'));
            }
        }
        $sectors = $this->IndicatorsSectors->Sectors->find('list', ['limit' => 200]);
        $this->set(compact('indicatorsSector', 'sectors'));
        $this->set('_serialize', ['indicatorsSector']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Indicators Sector id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($unit_id = null)
    {
        // $indicatorsSector = $this->IndicatorsSectors->get($id, [
        //     'contain' => []
        // ]);

        $unitsTable = TableRegistry::get('IndicatorsUnits');
        $indicatorsSector = $unitsTable->find()
        ->where(['IndicatorsUnits.unit_id =' => 1])
        ->contain(['Units']);
        $indicatorsSector = $indicatorsSector->first();


        if ($this->request->is(['patch', 'post', 'put'])) 
        {
            $indicatorsSector = $this->IndicatorsSectors->patchEntity($indicatorsSector, $this->request->data);

            if ($this->IndicatorsSectors->save($indicatorsSector)) 
            {
                $this->Flash->success(__('The indicators sector has been saved.'));
                return $this->redirect(['action' => 'edit', $unit_id]);
            } 
            else 
            {
                $this->Flash->error(__('The indicators sector could not be saved. Please, try again.'));
            }
        }

       // $sectors = $this->IndicatorsSectors->Sectors->find('list', ['limit' => 200]);
        $this->set(compact('indicatorsSector', 'sectors'));
        $this->set('_serialize', ['indicatorsSector']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Indicators Sector id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $indicatorsSector = $this->IndicatorsSectors->get($id);
        if ($this->IndicatorsSectors->delete($indicatorsSector)) {
            $this->Flash->success(__('The indicators sector has been deleted.'));
        } else {
            $this->Flash->error(__('The indicators sector could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
