<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * NasScore Entity.
 *
 * @property int $id
 * @property string $monitoramento_e_controles
 * @property string $investigacoes_laboratoriais
 * @property string $medicacao
 * @property string $procedimentos_de_higiene
 * @property string $cuidados_com_drenos
 * @property string $mobilizacao_e_posicionamento
 * @property string $suporte_e_cuidados_aos_familiares
 * @property string $tarefas_administrativas
 * @property string $suporte_ventilatorio
 * @property string $cuidado_com_vias_aereas
 * @property string $tratamento_para_funcao_pulmonar
 * @property string $medicacao_vasoativa
 * @property string $reposicao_iv_de_grandes_perdas_de_fluidos
 * @property string $monitoracao_com_cateter_de_swan_ganz
 * @property string $rcp_nas_ultimas_24h
 * @property string $tecnicas_de_suporte_renal
 * @property string $medida_do_debito_urinario
 * @property string $medida_da_pic
 * @property string $tratamento_da_acidose
 * @property string $nutricao_parenteral_total
 * @property string $nutricao_enteral
 * @property string $intervencoes_especificas_na_uti
 * @property string $intervencoes_especificas_fora_da_uti
 * @property \Cake\I18n\Time $data_de_realizacao
 * @property string $doenca_do_paciente
 * @property \Cake\I18n\Time $created
 * @property bool $active
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property string $pontuacao
 */
class NasScore extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
