<?php
namespace App\Model\Table;

use App\Model\Entity\IndicatorsUnit;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * IndicatorsUnits Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Units
 */
class IndicatorsUnitsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('indicators_units');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->numeric('taxa_de_ocupacao')
            ->allowEmpty('taxa_de_ocupacao');

        $validator
            ->numeric('indice_de_giro_de_leito')
            ->allowEmpty('indice_de_giro_de_leito');

        $validator
            ->numeric('intervalo_de_substituicao')
            ->allowEmpty('intervalo_de_substituicao');

        $validator
            ->numeric('idade_media')
            ->allowEmpty('idade_media');

        $validator
            ->numeric('consumo_medio')
            ->allowEmpty('consumo_medio');

        $validator
            ->numeric('consumo_diario')
            ->allowEmpty('consumo_diario');

        $validator
            ->numeric('consumo_diario_por_paciente')
            ->allowEmpty('consumo_diario_por_paciente');

        $validator
            ->numeric('ticket_medio')
            ->allowEmpty('ticket_medio');

        $validator
            ->numeric('ticket_diario')
            ->allowEmpty('ticket_diario');

        $validator
            ->numeric('ticket_diario_por_paciente')
            ->allowEmpty('ticket_diario_por_paciente');

        $validator
            ->numeric('ticket_por_internacao')
            ->allowEmpty('ticket_por_internacao');

        $validator
            ->numeric('glossa_total')
            ->allowEmpty('glossa_total');

        $validator
            ->numeric('glossa_por_paciente')
            ->allowEmpty('glossa_por_paciente');

        $validator
            ->numeric('faixa_de_internacao_menor_que_24h')
            ->allowEmpty('faixa_de_internacao_menor_que_24h');

        $validator
            ->numeric('faixa_de_internacao_ate_7_dias')
            ->allowEmpty('faixa_de_internacao_ate_7_dias');

        $validator
            ->numeric('faixa_de_internacao_ate_21_dias')
            ->allowEmpty('faixa_de_internacao_ate_21_dias');

        $validator
            ->numeric('faixa_de_internacao_ate_28_dias')
            ->allowEmpty('faixa_de_internacao_ate_28_dias');

        $validator
            ->numeric('faixa_de_internacao_superior_28_dias')
            ->allowEmpty('faixa_de_internacao_superior_28_dias');

        $validator
            ->numeric('taxa_de_reinternacao')
            ->allowEmpty('taxa_de_reinternacao');

        $validator
            ->numeric('percentual_de_altas')
            ->allowEmpty('percentual_de_altas');

        $validator
            ->time('tempo_de_permanencia_minimo')
            ->allowEmpty('tempo_de_permanencia_minimo');

        $validator
            ->time('tempo_de_permanencia_medio')
            ->allowEmpty('tempo_de_permanencia_medio');

        $validator
            ->time('tempo_de_permanencia_maximo')
            ->allowEmpty('tempo_de_permanencia_maximo');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        return $rules;
    }
}
