<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * ResponsiblesTelephones Controller
 *
 * @property \App\Model\Table\ResponsiblesTelephonesTable $ResponsiblesTelephones
 */
class ResponsiblesTelephonesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Responsibles', 'Telephones']
        ];
        $responsiblesTelephones = $this->paginate($this->ResponsiblesTelephones);

        $this->set(compact('responsiblesTelephones'));
        $this->set('_serialize', ['responsiblesTelephones']);
    }

    /**
     * View method
     *
     * @param string|null $id Responsibles Telephone id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $responsiblesTelephone = $this->ResponsiblesTelephones->get($id, [
            'contain' => ['Responsibles', 'Telephones']
        ]);

        $this->set('responsiblesTelephone', $responsiblesTelephone);
        $this->set('_serialize', ['responsiblesTelephone']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $responsiblesTelephone = $this->ResponsiblesTelephones->newEntity();
        if ($this->request->is('post')) {
            $responsiblesTelephone = $this->ResponsiblesTelephones->patchEntity($responsiblesTelephone, $this->request->data);
            if ($this->ResponsiblesTelephones->save($responsiblesTelephone)) {
                $this->Flash->success(__('The responsibles telephone has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The responsibles telephone could not be saved. Please, try again.'));
            }
        }
        $responsibles = $this->ResponsiblesTelephones->Responsibles->find('list', ['limit' => 200]);
        $telephones = $this->ResponsiblesTelephones->Telephones->find('list', ['limit' => 200]);
        $this->set(compact('responsiblesTelephone', 'responsibles', 'telephones'));
        $this->set('_serialize', ['responsiblesTelephone']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Responsibles Telephone id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $responsiblesTelephone = $this->ResponsiblesTelephones->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $responsiblesTelephone = $this->ResponsiblesTelephones->patchEntity($responsiblesTelephone, $this->request->data);
            if ($this->ResponsiblesTelephones->save($responsiblesTelephone)) {
                $this->Flash->success(__('The responsibles telephone has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The responsibles telephone could not be saved. Please, try again.'));
            }
        }
        $responsibles = $this->ResponsiblesTelephones->Responsibles->find('list', ['limit' => 200]);
        $telephones = $this->ResponsiblesTelephones->Telephones->find('list', ['limit' => 200]);
        $this->set(compact('responsiblesTelephone', 'responsibles', 'telephones'));
        $this->set('_serialize', ['responsiblesTelephone']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Responsibles Telephone id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $responsiblesTelephone = $this->ResponsiblesTelephones->get($id);
        if ($this->ResponsiblesTelephones->delete($responsiblesTelephone)) {
            $this->Flash->success(__('The responsibles telephone has been deleted.'));
        } else {
            $this->Flash->error(__('The responsibles telephone could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
