<?php
        echo $this->element('units-nav-bar');
?>


<div class="origins index col-md-10 col-lg-10 columns content">
    <h3 class="big-title">Origem</h3>
    <br>   
    <?php    
        echo $this->Html->link('Nova Origem',
            ['controller' => 'Origins', 'action' => 'add', $unit_id]
            , array('class' => 'link-bt'));  
    ?>
    <br><br>   
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('category', array('label'=>'Categoria')) ?></th>
                <th><?= $this->Paginator->sort('name', array('label'=>'Nome')) ?></th>
                <th><?= $this->Paginator->sort('unit_id', array('label'=>'Unidade')) ?></th>
                <th><?= $this->Paginator->sort('is_active', array('label'=>'Status')) ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($origins as $origin): ?>
            <tr>
                <td><?= h($origin->category) ?></td>
                <td><?= h($origin->name) ?></td>
                <td><?= $origin->has('unit') ? $this->Html->link($origin->unit->name, ['controller' => 'Units', 'action' => 'view', $origin->unit->id]) : '' ?></td>
                <td>
                    <?php
                         if ( h($origin->is_active) == 1)
                            {echo"Ativo";}
                        else
                            {echo "Suspenso";}
                     ?>
                </td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('Editar'), ['action' => 'edit', $origin->id, $unit_id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Deletar'), ['action' => 'delete', $origin->id], ['confirm' => __('Tem certeza que deseja deletar  # {0}?', $origin->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
            </ul>           
        </div>
    </center>
</div>
</div>