<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Discharges Controller
 *
 * @property \App\Model\Table\DischargesTable $Discharges
 */
class DischargesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations']
        ];
        $discharges = $this->paginate($this->Discharges);

        $this->set(compact('discharges'));
        $this->set('_serialize', ['discharges']);
    }

    /**
     * View method
     *
     * @param string|null $id Discharge id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $discharge = $this->Discharges->get($id, [
            'contain' => ['Hospitalizations']
        ]);

        $this->set('discharge', $discharge);
        $this->set('_serialize', ['discharge']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $discharge = $this->Discharges->newEntity();
        if ($this->request->is('post')) {
            $discharge = $this->Discharges->patchEntity($discharge, $this->request->data);
            if ($this->Discharges->save($discharge)) {
                $this->Flash->success(__('The discharge has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The discharge could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->Discharges->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('discharge', 'hospitalizations'));
        $this->set('_serialize', ['discharge']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Discharge id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $discharge = $this->Discharges->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $discharge = $this->Discharges->patchEntity($discharge, $this->request->data);
            if ($this->Discharges->save($discharge)) {
                $this->Flash->success(__('The discharge has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The discharge could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->Discharges->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('discharge', 'hospitalizations'));
        $this->set('_serialize', ['discharge']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Discharge id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $discharge = $this->Discharges->get($id);
        if ($this->Discharges->delete($discharge)) {
            $this->Flash->success(__('The discharge has been deleted.'));
        } else {
            $this->Flash->error(__('The discharge could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
