<?php
namespace App\Model\Table;

use App\Model\Entity\Room;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Rooms Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Sectors
 */
class RoomsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('rooms');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
         $validator
            ->notEmpty('name');

        $validator
            ->integer('id')
            ->notEmpty('id', 'create');

        // $validator
        //     ->requirePresence('type', 'create')
        //     ->notEmpty('type');

        // $validator
        //     ->integer('limit_of_patients')
        //     ->requirePresence('limit_of_patients', 'create')
        //     ->notEmpty('limit_of_patients');
        // $validator
        //     ->requirePresence('limit_of_rooms')
        //     ->notEmpty('limit_of_rooms', 'Este campo é obrigatório.')
        //     ->add('limit_of_rooms', [
        //         'length' => [
        //             'rule' => ['minLength', 3],
        //             'message' => 'O limite é de até 999 leitos.',
        //         ]
        //     ]);

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['sector_id'], 'Sectors'));
        return $rules;
    }
}
