<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Comorbidities Diagnostic']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Comorbidities']), ['controller' => 'Comorbidities', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Comorbidity']), ['controller' => 'Comorbidities', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Diagnostics']), ['controller' => 'Diagnostics', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Diagnostic']), ['controller' => 'Diagnostics', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="comorbiditiesDiagnostics index col-md-10 columns content">
    <h3>Comorbidities Diagnostics</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('comorbidity_id') ?></th>
                <th><?= $this->Paginator->sort('diagnostic_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($comorbiditiesDiagnostics as $comorbiditiesDiagnostic): ?>
            <tr>
                <td><?= $this->Number->format($comorbiditiesDiagnostic->id) ?></td>
                <td><?= $comorbiditiesDiagnostic->has('comorbidity') ? $this->Html->link($comorbiditiesDiagnostic->comorbidity->name, ['controller' => 'Comorbidities', 'action' => 'view', $comorbiditiesDiagnostic->comorbidity->id]) : '' ?></td>
                <td><?= $comorbiditiesDiagnostic->has('diagnostic') ? $this->Html->link($comorbiditiesDiagnostic->diagnostic->id, ['controller' => 'Diagnostics', 'action' => 'view', $comorbiditiesDiagnostic->diagnostic->id]) : '' ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $comorbiditiesDiagnostic->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $comorbiditiesDiagnostic->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $comorbiditiesDiagnostic->id], ['confirm' => __('Are you sure you want to delete # {0}?', $comorbiditiesDiagnostic->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>