<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Prescription']), ['action' => 'edit', $prescription->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Prescription']), ['action' => 'delete', $prescription->id], ['confirm' => __('Are you sure you want to delete # {0}?', $prescription->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Prescriptions']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Prescription']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="prescriptions view col-lg-10 col-md-9">
    <h3><?= h($prescription->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Precaution</th>
            <td><?= h($prescription->precaution) ?></td>
        </tr>
        <tr>
            <th>Germs</th>
            <td><?= h($prescription->germs) ?></td>
        </tr>
        <tr>
            <th>Nutrition</th>
            <td><?= h($prescription->nutrition) ?></td>
        </tr>
        <tr>
            <th>Speech Therapy</th>
            <td><?= h($prescription->speech_therapy) ?></td>
        </tr>
        <tr>
            <th>Odontology</th>
            <td><?= h($prescription->odontology) ?></td>
        </tr>
        <tr>
            <th>Hospitalization</th>
            <td><?= $prescription->has('hospitalization') ? $this->Html->link($prescription->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $prescription->hospitalization->id]) : '' ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($prescription->id) ?></td>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($prescription->created) ?></tr>
        </tr>
        <tr>
            <th>Is Active</th>
            <td><?= $prescription->is_active ? __('Yes') : __('No'); ?></td>
         </tr>
    </table>
</div>
