<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Screening']), ['action' => 'edit', $screening->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Screening']), ['action' => 'delete', $screening->id], ['confirm' => __('Are you sure you want to delete # {0}?', $screening->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Screenings']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Screening']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Patients']), ['controller' => 'Patients', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Patient']), ['controller' => 'Patients', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Units']), ['controller' => 'Units', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Unit']), ['controller' => 'Units', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Bundles']), ['controller' => 'Bundles', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Bundle']), ['controller' => 'Bundles', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Medical Cares']), ['controller' => 'MedicalCares', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Care']), ['controller' => 'MedicalCares', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="screenings view col-lg-10 col-md-9">
    <h3><?= h($screening->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Complaint</th>
            <td><?= h($screening->complaint) ?></td>
        </tr>
        <tr>
            <th>Allergy</th>
            <td><?= h($screening->allergy) ?></td>
        </tr>
        <tr>
            <th>Pre Existing Diseases</th>
            <td><?= h($screening->pre_existing_diseases) ?></td>
        </tr>
        <tr>
            <th>Height</th>
            <td><?= h($screening->height) ?></td>
        </tr>
        <tr>
            <th>Weight</th>
            <td><?= h($screening->weight) ?></td>
        </tr>
        <tr>
            <th>Pulse</th>
            <td><?= h($screening->pulse) ?></td>
        </tr>
        <tr>
            <th>Pa</th>
            <td><?= h($screening->pa) ?></td>
        </tr>
        <tr>
            <th>Respiration</th>
            <td><?= h($screening->respiration) ?></td>
        </tr>
        <tr>
            <th>Temperature</th>
            <td><?= h($screening->temperature) ?></td>
        </tr>
        <tr>
            <th>Saturation</th>
            <td><?= h($screening->saturation) ?></td>
        </tr>
        <tr>
            <th>Capillary Glycemia</th>
            <td><?= h($screening->capillary_glycemia) ?></td>
        </tr>
        <tr>
            <th>Pain Intensity</th>
            <td><?= h($screening->pain_intensity) ?></td>
        </tr>
        <tr>
            <th>Pain Characteristics</th>
            <td><?= h($screening->pain_characteristics) ?></td>
        </tr>
        <tr>
            <th>Appraiser Identification</th>
            <td><?= h($screening->appraiser_identification) ?></td>
        </tr>
        <tr>
            <th>Nursing Notes</th>
            <td><?= h($screening->nursing_notes) ?></td>
        </tr>
        <tr>
            <th>Risk Rating</th>
            <td><?= h($screening->risk_rating) ?></td>
        </tr>
        <tr>
            <th>Patient</th>
            <td><?= $screening->has('patient') ? $this->Html->link($screening->patient->id, ['controller' => 'Patients', 'action' => 'view', $screening->patient->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Unit</th>
            <td><?= $screening->has('unit') ? $this->Html->link($screening->unit->name, ['controller' => 'Units', 'action' => 'view', $screening->unit->id]) : '' ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($screening->id) ?></td>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($screening->created) ?></tr>
        </tr>
        <tr>
            <th>Electrocardiogram</th>
            <td><?= $screening->Electrocardiogram ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Is Active</th>
            <td><?= $screening->is_active ? __('Yes') : __('No'); ?></td>
         </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Bundles']) ?></h4>
        <?php if (!empty($screening->bundles)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Date Instalation</th>
                <th>Hour Instalation</th>
                <th>Professional Id</th>
                <th>Hospitalization Id</th>
                <th>Screening Id</th>
                <th>Type Of Device</th>
                <th>Created</th>
                <th>Emergency</th>
                <th>Is Risk Of Bleeding Verified</th>
                <th>Is The Procedure Prescribed</th>
                <th>Device Observation</th>
                <th>Proper Handwashing</th>
                <th>Use Of Paramentation</th>
                <th>Use Of Antisepsis</th>
                <th>Use Of Field With Maxium Barrier</th>
                <th>Use Of Sterile Gel</th>
                <th>Suitable Catheter Progression</th>
                <th>Urine Output Cauterization</th>
                <th>Adequate Catheter Fixation</th>
                <th>Confirmation Of Position With Us</th>
                <th>Checklist Observation</th>
                <th>Number Of Retries</th>
                <th>Single Procedure</th>
                <th>Number Of Professionals</th>
                <th>Blood On Catheter</th>
                <th>Successful Integration</th>
                <th>Immediate Complications</th>
                <th>Date Of Withdrawal</th>
                <th>Withdrawal Time</th>
                <th>Accidental Removal</th>
                <th>Reason For Inclusion</th>
                <th>Reinsert Time</th>
                <th>Reinsert Date</th>
                <th>Citostimia</th>
                <th>Type</th>
                <th>Degermacao Pele Clorohexidine</th>
                <th>Antisepsia Pele Clorohexidine</th>
                <th>Asseptica Durante Procedimento</th>
                <th>Ultrasom Durante Procedimento</th>
                <th>Troca Introducar Picc</th>
                <th>Curativo Tecnica Esteril</th>
                <th>Verificado Risco Dificuldade</th>
                <th>Risco De Dificuldade</th>
                <th>Tci Preenchido</th>
                <th>Degermacao Da Genitalia</th>
                <th>Curativo Tecnica Steril</th>
                <th>Conectores Cvc</th>
                <th>Radiografia De Controle</th>
                <th>Apos Proce Observacao</th>
                <th>Is Utu</th>
                <th>Pontuation</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($screening->bundles as $bundles): ?>
            <tr>
                <td><?= h($bundles->id) ?></td>
                <td><?= h($bundles->date_instalation) ?></td>
                <td><?= h($bundles->hour_instalation) ?></td>
                <td><?= h($bundles->professional_id) ?></td>
                <td><?= h($bundles->hospitalization_id) ?></td>
                <td><?= h($bundles->screening_id) ?></td>
                <td><?= h($bundles->type_of_device) ?></td>
                <td><?= h($bundles->created) ?></td>
                <td><?= h($bundles->emergency) ?></td>
                <td><?= h($bundles->is_risk_of_bleeding_verified) ?></td>
                <td><?= h($bundles->is_the_procedure_prescribed) ?></td>
                <td><?= h($bundles->device_observation) ?></td>
                <td><?= h($bundles->proper_handwashing) ?></td>
                <td><?= h($bundles->use_of_paramentation) ?></td>
                <td><?= h($bundles->use_of_antisepsis) ?></td>
                <td><?= h($bundles->use_of_field_with_maxium_barrier) ?></td>
                <td><?= h($bundles->use_of_sterile_gel) ?></td>
                <td><?= h($bundles->suitable_catheter_progression) ?></td>
                <td><?= h($bundles->urine_output_cauterization) ?></td>
                <td><?= h($bundles->adequate_catheter_fixation) ?></td>
                <td><?= h($bundles->confirmation_of_position_with_us) ?></td>
                <td><?= h($bundles->checklist_observation) ?></td>
                <td><?= h($bundles->number_of_retries) ?></td>
                <td><?= h($bundles->single_procedure) ?></td>
                <td><?= h($bundles->number_of_professionals) ?></td>
                <td><?= h($bundles->blood_on_catheter) ?></td>
                <td><?= h($bundles->successful_integration) ?></td>
                <td><?= h($bundles->immediate_complications) ?></td>
                <td><?= h($bundles->date_of_withdrawal) ?></td>
                <td><?= h($bundles->withdrawal_time) ?></td>
                <td><?= h($bundles->accidental_removal) ?></td>
                <td><?= h($bundles->reason_for_inclusion) ?></td>
                <td><?= h($bundles->reinsert_time) ?></td>
                <td><?= h($bundles->reinsert_date) ?></td>
                <td><?= h($bundles->citostimia) ?></td>
                <td><?= h($bundles->type) ?></td>
                <td><?= h($bundles->degermacao_pele_clorohexidine) ?></td>
                <td><?= h($bundles->antisepsia_pele_clorohexidine) ?></td>
                <td><?= h($bundles->asseptica_durante_procedimento) ?></td>
                <td><?= h($bundles->ultrasom_durante_procedimento) ?></td>
                <td><?= h($bundles->troca_introducar_picc) ?></td>
                <td><?= h($bundles->curativo_tecnica_esteril) ?></td>
                <td><?= h($bundles->verificado_risco_dificuldade) ?></td>
                <td><?= h($bundles->risco_de_dificuldade) ?></td>
                <td><?= h($bundles->tci_preenchido) ?></td>
                <td><?= h($bundles->degermacao_da_genitalia) ?></td>
                <td><?= h($bundles->curativo_tecnica_steril) ?></td>
                <td><?= h($bundles->conectores_cvc) ?></td>
                <td><?= h($bundles->radiografia_de_controle) ?></td>
                <td><?= h($bundles->apos_proce_observacao) ?></td>
                <td><?= h($bundles->is_utu) ?></td>
                <td><?= h($bundles->pontuation) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Bundles', 'action' => 'view', $bundles->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Bundles', 'action' => 'edit', $bundles->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Bundles', 'action' => 'delete', $bundles->id], ['confirm' => __('Are you sure you want to delete # {0}?', $bundles->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Hospitalizations']) ?></h4>
        <?php if (!empty($screening->hospitalizations)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Patient Id</th>
                <th>Health Care Number</th>
                <th>Type</th>
                <th>Complementary Health</th>
                <th>Expected Discharge Day</th>
                <th>Screening Id</th>
                <th>Origin Id</th>
                <th>Unit Id</th>
                <th>Created</th>
                <th>Updated</th>
                <th>Readmission To Hospital Until 30 Days</th>
                <th>Rehospitalization Up 24</th>
                <th>Weight</th>
                <th>Height</th>
                <th>Systemic Diagnosis</th>
                <th>Sector Id</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($screening->hospitalizations as $hospitalizations): ?>
            <tr>
                <td><?= h($hospitalizations->id) ?></td>
                <td><?= h($hospitalizations->patient_id) ?></td>
                <td><?= h($hospitalizations->health_care_number) ?></td>
                <td><?= h($hospitalizations->type) ?></td>
                <td><?= h($hospitalizations->complementary_health) ?></td>
                <td><?= h($hospitalizations->expected_discharge_day) ?></td>
                <td><?= h($hospitalizations->screening_id) ?></td>
                <td><?= h($hospitalizations->origin_id) ?></td>
                <td><?= h($hospitalizations->unit_id) ?></td>
                <td><?= h($hospitalizations->created) ?></td>
                <td><?= h($hospitalizations->updated) ?></td>
                <td><?= h($hospitalizations->readmission_to_hospital_until_30_days) ?></td>
                <td><?= h($hospitalizations->rehospitalization_up_24) ?></td>
                <td><?= h($hospitalizations->weight) ?></td>
                <td><?= h($hospitalizations->height) ?></td>
                <td><?= h($hospitalizations->systemic_diagnosis) ?></td>
                <td><?= h($hospitalizations->sector_id) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Hospitalizations', 'action' => 'view', $hospitalizations->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Hospitalizations', 'action' => 'edit', $hospitalizations->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Hospitalizations', 'action' => 'delete', $hospitalizations->id], ['confirm' => __('Are you sure you want to delete # {0}?', $hospitalizations->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Medical Cares']) ?></h4>
        <?php if (!empty($screening->medical_cares)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Origin</th>
                <th>Register Number</th>
                <th>Allergy</th>
                <th>Created</th>
                <th>Hda</th>
                <th>Hpp</th>
                <th>Clinical Examination</th>
                <th>Pa</th>
                <th>Fc</th>
                <th>Spo2</th>
                <th>Fr</th>
                <th>Temp</th>
                <th>Glicemia</th>
                <th>Laboratory Examination</th>
                <th>Chest Tomography</th>
                <th>Tomography</th>
                <th>Noradrenalina</th>
                <th>Vasopressina</th>
                <th>Dobutamina</th>
                <th>Glasgow</th>
                <th>Nipride</th>
                <th>Tridi</th>
                <th>Ancoron</th>
                <th>Pcr Previa</th>
                <th>Midazolam</th>
                <th>Fentanil</th>
                <th>Insulina</th>
                <th>Dexmedetomidina</th>
                <th>Morfina</th>
                <th>Reavaluation Need</th>
                <th>Diagnostic Impression</th>
                <th>Medical Carescol</th>
                <th>Conduct</th>
                <th>Screening Id</th>
                <th>Is Active</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($screening->medical_cares as $medicalCares): ?>
            <tr>
                <td><?= h($medicalCares->id) ?></td>
                <td><?= h($medicalCares->origin) ?></td>
                <td><?= h($medicalCares->register_number) ?></td>
                <td><?= h($medicalCares->allergy) ?></td>
                <td><?= h($medicalCares->created) ?></td>
                <td><?= h($medicalCares->hda) ?></td>
                <td><?= h($medicalCares->hpp) ?></td>
                <td><?= h($medicalCares->clinical_examination) ?></td>
                <td><?= h($medicalCares->pa) ?></td>
                <td><?= h($medicalCares->fc) ?></td>
                <td><?= h($medicalCares->spo2) ?></td>
                <td><?= h($medicalCares->fr) ?></td>
                <td><?= h($medicalCares->temp) ?></td>
                <td><?= h($medicalCares->glicemia) ?></td>
                <td><?= h($medicalCares->laboratory_examination) ?></td>
                <td><?= h($medicalCares->chest_tomography) ?></td>
                <td><?= h($medicalCares->tomography) ?></td>
                <td><?= h($medicalCares->noradrenalina) ?></td>
                <td><?= h($medicalCares->vasopressina) ?></td>
                <td><?= h($medicalCares->dobutamina) ?></td>
                <td><?= h($medicalCares->glasgow) ?></td>
                <td><?= h($medicalCares->nipride) ?></td>
                <td><?= h($medicalCares->tridi) ?></td>
                <td><?= h($medicalCares->ancoron) ?></td>
                <td><?= h($medicalCares->pcr_previa) ?></td>
                <td><?= h($medicalCares->midazolam) ?></td>
                <td><?= h($medicalCares->fentanil) ?></td>
                <td><?= h($medicalCares->insulina) ?></td>
                <td><?= h($medicalCares->dexmedetomidina) ?></td>
                <td><?= h($medicalCares->morfina) ?></td>
                <td><?= h($medicalCares->reavaluation_need) ?></td>
                <td><?= h($medicalCares->diagnostic_impression) ?></td>
                <td><?= h($medicalCares->medical_carescol) ?></td>
                <td><?= h($medicalCares->conduct) ?></td>
                <td><?= h($medicalCares->screening_id) ?></td>
                <td><?= h($medicalCares->is_active) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'MedicalCares', 'action' => 'view', $medicalCares->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'MedicalCares', 'action' => 'edit', $medicalCares->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'MedicalCares', 'action' => 'delete', $medicalCares->id], ['confirm' => __('Are you sure you want to delete # {0}?', $medicalCares->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
