<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Infections Controller
 *
 * @property \App\Model\Table\InfectionsTable $Infections
 */
class InfectionsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Infecções');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
            'order' => ['created'=>'desc']
        ];
        $infections = $this->paginate($this->Infections);

        $this->set(compact('infections'));
        $this->set('_serialize', ['infections']);
    }

    /**
     * View method
     *
     * @param string|null $id Infection id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $infection = $this->Infections->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('infection', $infection);
        $this->set('_serialize', ['infection']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $session            = $this->request->session();
        $hospitalization_id = $session->read('selected-hospitalization');

        $infection = $this->Infections->newEntity();
        if ($this->request->is('post')) {
            $infection = $this->Infections->patchEntity($infection, $this->request->data);
            if ($this->Infections->save($infection)) {
                $this->Flash->success(__('The infection has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The infection could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->Infections->Hospitalizations->find('list', ['limit' => 200]);
        $cultures         = $this->Infections->Cultures->find('list', [
            'limit'      => 200,
            'fields'     => ['id', 'germe'],
            'conditions' => ['Cultures.hospitalization_id' => $hospitalization_id,
                'OR'                                           => [
                    ['Cultures.resultado' => 0],
                    ['Cultures.resultado' => 1],
                ],
            ],
        ]);

        $this->set(compact('infection', 'hospitalizations', 'cultures'));
        $this->set('_serialize', ['infection']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Infection id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $session            = $this->request->session();
        $hospitalization_id = $session->read('selected-hospitalization');

        $infection = $this->Infections->get($id, [
            'contain' => ['Cultures'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $infection = $this->Infections->patchEntity($infection, $this->request->data);
            if ($this->Infections->save($infection)) {
                $this->Flash->success(__('The infection has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The infection could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->Infections->Hospitalizations->find('list', ['limit' => 200]);
        $cultures         = $this->Infections->Cultures->find('list', [
            'limit'      => 200,
            'fields'     => ['id', 'germe'],
            'conditions' => ['Cultures.hospitalization_id' => $hospitalization_id,
                'OR'                                           => [
                    ['Cultures.resultado' => 0],
                    ['Cultures.resultado' => 1],
                ],
            ],
        ]);
        $this->set(compact('infection', 'hospitalizations', 'cultures'));
        $this->set('_serialize', ['infection']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Infection id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $infection = $this->Infections->get($id);
        if ($this->Infections->delete($infection)) {
            $this->Flash->success(__('The infection has been deleted.'));
        } else {
            $this->Flash->error(__('The infection could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
