<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * ApacheIiScores Controller
 *
 * @property \App\Model\Table\ApacheIiScoresTable $ApacheIiScores
 */
class RelatoriosController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('RequestHandler');

        $this->loadComponent('RequestHandler');

        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);

        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Relatórios');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return true;
        return $this->Permission->hasPermission($user['role_name'], 'Relatorios', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $hospitalizations_id = $this->request->session()->read('selected-hospitalization');

// $this->paginate = [

//     'contain' => ['Hospitalizations'],
        // ];
        $this->paginate = [
            'contain' => ['NasScores', 'ApacheIiScores', 'PreDeliricScores', 'SnapIiScores', 'SapsIiiScores', 'SofaEscores', 'CribScores'],
            'conditions' => ['Hospitalizations.id =' => $hospitalizations_id],

        ];
        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $scores = $this->paginate($hospitalizations_table);

        //$apacheIiScores = $this->paginate($this->ApacheIiScores);

        $this->set(compact('scores'));
        $this->set('_serialize', ['scores']);
    }

    public function dashboard()
    {
    }

    public function setDate($date_before = null, $date_after = null)
    {
        $this->autoRender = false;

        if ($this->request->is('Ajax'))
        {
            $session = $this->request->session();

            if (isset($this->request->query['date_before']) && $this->request->query['date_before'] !== "")
            {
                $date_before = $this->request->query['date_before'];
                $session->write('date_before', $date_before);
            }

            if (isset($this->request->query['date_after']) && $this->request->query['date_after'] !== "")
            {
                $date_after = $this->request->query['date_after'];
                $session->write('date_after', $date_after);
            }

//$date_after  = $this->request->query['date_after'];

// $date_before = $this->request->params["date_before"];
            // $date_after  = $this->request->params["date_after"];

            $this->response->body
                (
                json_encode(
                    [
                        "date_before" => $date_before,
                        "date_after" => $date_after,
                    ])
            );
            return $this->response;

// echo $action = $this->request->params["date_after"];

// echo $action = $this->request->params["date_before"];

            //echo json_encode($date_before, $date_after);
        }
    }

    public function view($id = null)
    {
        $patient_table = TableRegistry::get('Patients');
        $patient = $patient_table->get($id);
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Patient ' . $id . '.pdf',
            ],
        ]);
        $this->set('patient', $patient);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $apacheIiScore = $this->ApacheIiScores->newEntity();

        if ($this->request->is('post'))
        {
            $apacheIiScore = $this->ApacheIiScores->patchEntity($apacheIiScore, $this->request->data);

            if ($this->ApacheIiScores->save($apacheIiScore))
            {
                $this->Flash->success(__('O registro foi salvo..'));
                return $this->redirect(['action' => 'index']);
            }
            else
            {
                Log::write('debug', $apacheIiScore);
                Log::write('debug', $apacheIiScore->errors());
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }

        $hospitalizations = $this->ApacheIiScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('apacheIiScore', 'hospitalizations'));
        $this->set('_serialize', ['apacheIiScore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Apache Ii Score id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $apacheIiScore = $this->ApacheIiScores->get($id, [
            'contain' => [],
        ]);

        if ($this->request->is(['patch', 'post', 'put']))
        {
            $apacheIiScore = $this->ApacheIiScores->patchEntity($apacheIiScore, $this->request->data);

            if ($this->ApacheIiScores->save($apacheIiScore))
            {
                $this->Flash->success(__('O registro foi salvo..'));
                return $this->redirect(['action' => 'index']);
            }
            else
            {
                $this->Flash->error(__('O registro não foi salvo. Por favor, tente novamente.'));
            }
        }

        $hospitalizations = $this->ApacheIiScores->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('apacheIiScore', 'hospitalizations'));
        $this->set('_serialize', ['apacheIiScore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Apache Ii Score id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $apacheIiScore = $this->ApacheIiScores->get($id);

        if ($this->ApacheIiScores->delete($apacheIiScore))
        {
            $this->Flash->success(__('O registro foi deletado'));
        }
        else
        {
            $this->Flash->error(__('O registro não foi deletado. Por favor, tente novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function nutritionalAssessments()
    {
        $calc_obj = new MedidasDispersao();

        $session = $this->request->session();
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');

        $arr = [
            'patients_id' => [],
            'cirurgica' => [
                'nutrition_evolution' => 0,
                'nutrition_evolution_leve' => 0,
                'nutrition_evolution_moderada' => 0,
                'nutrition_evolution_grave' => 0,

                'media_indice_nutricional_arr' => [],
                'media_indice_nutricional' => 0,

                'variacao_indice_nutricional' => 0,

                'geb_calometria_indireta' => [],
                'geb_calometria_indireta_percent' => 0,
                'geb_calometria_indireta_circulatoria' => [],
                'geb_calometria_indireta_circulatoria_percent' => 0,

                'media_jejum' => [],
            ],

            'clinica' => [
                'nutrition_evolution' => 0,
                'nutrition_evolution_leve' => 0,
                'nutrition_evolution_moderada' => 0,
                'nutrition_evolution_grave' => 0,

                'media_indice_nutricional_arr' => [],
                'media_indice_nutricional' => 0,

                'variacao_indice_nutricional' => 0,

                'geb_calometria_indireta' => [],
                'geb_calometria_indireta_percent' => 0,
                'geb_calometria_indireta_circulatoria' => [],
                'geb_calometria_indireta_circulatoria_percent' => 0,

                'media_jejum' => [],
            ],
            'geral' => [
                'nutrition_evolution' => 0,
                'nutrition_evolution_leve' => 0,
                'nutrition_evolution_moderada' => 0,
                'nutrition_evolution_grave' => 0,

                'media_indice_nutricional_arr' => [],
                'media_indice_nutricional' => 0,

                'variacao_indice_nutricional' => 0,

                'geb_calometria_indireta' => [],
                'geb_calometria_indireta_percent' => 0,
                'geb_calometria_indireta_circulatoria' => [],
                'geb_calometria_indireta_circulatoria_percent' => 0,

                'media_jejum' => [],

            ],
        ];

        $hospital_ids = [];
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $cont = 0;

        $evolution = [
            'cirurgica' => [],
            'geral' => [],
            'clinica' => [],
        ];

        $evo = [
            'cirurgica' => [],
            'geral' => [],
            'clinica' => [],
        ];

        $nutrition = [];

        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $nutrition_table = TableRegistry::get('NutritionalAssessments');

        $hospital_result = $hospitalizations_table
            ->find()
            ->where(['Hospitalizations.unit_id =' => $unit_id])
            ->toArray()
        ;

//pega o id das internações separando por tipo
        foreach ($hospital_result as $key => $value)
        {
            if (strpos($value['type'], 'Clínica') !== false)
            {
                $hospital_ids['clinica'][] = $value['id'];
            }

            if (strpos($value['type'], 'Cirúr') !== false)
            {
                $hospital_ids['cirurgica'][] = $value['id'];
            }

            $hospital_ids['geral'][] = $value['id'];

            if (in_array($value['patient_id'], $arr['patients_id']) == false)
            {
                array_push($arr['patients_id'], $value['patient_id']);
            }
        }

//cada tipo de internação(clinica, cirurgica)
        foreach ($hospital_ids as $type => $typeArr)
        {
            $cont = 0;
            $nutrition[$type] = $nutrition_table
                ->find()
                ->contain(['Hospitalizations'])
                ->where(['NutritionalAssessments.hospitalization_id IN' => $hospital_ids[$type],
                    'NutritionalAssessments.created >\'' . $date_before . '\' and NutritionalAssessments.created < \'' . $date_after . '\'',
                ])
                ->order(['NutritionalAssessments.created' => 'DESC'])
                ->toArray()
            ;

            foreach ($nutrition[$type] as $key => $value)
            {
                $cont++;
                $arr[$type]['media_indice_nutricional'] += $value['nutric_score'];

                array_push($arr[$type]['media_indice_nutricional_arr'], $value['nutric_score']);

                if ($value['nutric_score'] == 1)
                {
                    $evolution[$type] = $value['hospitalization_id'];
                }

//cálcula a quantidade de pacientes que utilizaram o GEB
                if ($value['geb_type'] == 2)
                {
//calcula o valor absoluto do geb
                    if (in_array($value['hospitalization_id'], $arr[$type]['geb_calometria_indireta']) == false)
                    {
                        array_push($arr[$type]['geb_calometria_indireta'], $value['hospitalization_id']);
                    }

//$arr[$type]['geb_calometria_indireta']++;

                    //calcula o percentual do geb
                    $arr[$type]['geb_calometria_indireta_percent'] = $calc_obj->calculate_percentage(count($arr[$type]['geb_calometria_indireta']), count($arr['patients_id']));
                }
                elseif ($value['geb_type'] == 3)
                {

//calcula o valor absoluto do geb

//$arr[$type]['geb_calometria_indireta_circulatoria']++;
                    if (in_array($value['hospitalization_id'], $arr[$type]['geb_calometria_indireta_circulatoria']) == false)
                    {
                        array_push($arr[$type]['geb_calometria_indireta_circulatoria'], $value['hospitalization_id']);
                    }

                    //calcula o percentual do geb
                    $arr[$type]['geb_calometria_indireta_circulatoria_percent'] = $calc_obj->calculate_percentage(count($arr[$type]['geb_calometria_indireta_circulatoria']), count($arr['patients_id']));
                }

                if (isset($value['periodo_jejum_data']) && isset($value['jejum_end_date']))
                {
                    //$arr[$type]['media_jejum']
                }

//checa se o paciente evoluiu no quadro de nutric_score partindo do número 1
                /*
                 * como a função in_array não aceita arrays multidimensionais foi criado um
                 * array para receber o índice do array multidimensional
                 */
                $dummyArrEvolution[] = $evolution[$type];
                $dummyArrEvo[] = $evo[$type];

                if (
                    (in_array($value['hospitalization_id'], $dummyArrEvo) == false)
                    && (in_array($value['hospitalization_id'], $dummyArrEvolution))
                )
                {
                    if ($value['nutric_score'] > 1)
                    {
                        $arr[$type]['nutrition_evolution']++;
                        $evo[$type][] = $value['hospitalization_id'];
                    }
                }
            }

            //calcula a média do índice (total / quantidade)
            $arr[$type]['media_indice_nutricional'] = $calc_obj->calc_average($arr[$type]['media_indice_nutricional_arr']);
            $arr[$type]['variacao_indice_nutricional'] = $calc_obj->calc_variance($arr[$type]['media_indice_nutricional_arr']);
        }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório de Avaliação Nutricional.pdf',
            ],
        ]);

        $this->set('nutrition', $arr);
    }

    public function bundleCateterVesical()
    {

        $hospital_ids = [];
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $cont = 0;

// $evolution = [

//     'cirurgica' => [],

//     'geral'     => [],

//     'clinica'   => [],

// ];

// $evo = [

//     'cirurgica' => [],

//     'geral'     => [],

//     'clinica'   => [],

// ];

// $nutrition = [];

// $hospitalizations_table = TableRegistry::get('Hospitalizations');

// $nutrition_table        = TableRegistry::get('NutritionalAssessments');

// $hospital_result = $hospitalizations_table

//     ->find()

//     // ->select(['id'])

//     ->where(['Hospitalizations.unit_id =' => $unit_id])

//     ->toArray()

// ;

// //pega o id das internações separando por tipo

// foreach ($hospital_result as $key => $value) {

//     if ($value['type'] == "Clínica") {

//         $hospital_ids['clinica'][] = $value['id'];

//     }

//     if ($value['type'] == "Cirúrgica") {

//         $hospital_ids['cirurgica'][] = $value['id'];

//     }

//     $hospital_ids['geral'][] = $value['id'];

// }

// //cada tipo de internação(clinica, cirurgica)

// foreach ($hospital_ids as $type => $typeArr) {

//     $cont             = 0;

//     $nutrition[$type] = $nutrition_table

//         ->find()

//         ->where(['NutritionalAssessments.hospitalization_id IN' => $hospital_ids[$type]])

//         ->order(['NutritionalAssessments.created' => 'DESC'])

//         ->toArray()

//     ;

//     foreach ($nutrition[$type] as $key => $value) {

//         $cont++;

//         $arr[$type]['media_indice_nutricional'] += $value['nutric_score'];

//         //array_push($arr, $value);

//         //$arr[$type] = $value;

//         if ($value['nutric_score'] == 1) {

//             $evolution[$type] = $value['hospitalization_id'];

//         }

//     }

//     //checa se o infeliz evoluiu no quadro de nutric_score partindo do número 1

//     foreach ($nutrition[$type] as $key => $value) {

//         //como a função in_array não aceita arrays multidimensionais criei um

//         //array para receber o indice do array multidimensional

//         $dummyArrEvolution[] = $evolution[$type];

//         $dummyArrEvo[]       = $evo[$type];

//         if (

//             (in_array($value['hospitalization_id'], $dummyArrEvo) == false)

//             && (in_array($value['hospitalization_id'], $dummyArrEvolution))

//         ) {

//             if ($value['nutric_score'] > 1) {

//                 $arr[$type]['nutrition_evolution']++;

//                 $evo[$type][] = $value['hospitalization_id'];

//             }

//         }

//     }

//     //gera a media do indice(total / quantidade)

//     $arr[$type]['media_indice_nutricional'] = $arr[$type]['media_indice_nutricional'] / $cont;
        // }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório de Cateter Vesical.pdf',
            ],
        ]);

        $this->set('nutrition', 'arr');
    }

    public function bundleCateterVascular()
    {
        $hospitalization_ids = [];

        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');
        $date = [
            "total_bundles" => 0,
            "total_pacientes" => 0,
            "percent_bundles_pacientes" => 0,
        ];
        $pacient_ids = [];

// $evolution = [

//     'cirurgica' => [],

//     'geral'     => [],

//     'clinica'   => [],

// ];

// $evo = [

//     'cirurgica' => [],

//     'geral'     => [],

//     'clinica'   => [],

// ];
        // $nutrition = [];

        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $bundles_table = TableRegistry::get('Bundles');

        $hospitalizations = $hospitalizations_table->find('all',
            ['conditions' => ['Hospitalizations.unit_id' => $unit_id],
            ]);

        foreach ($hospitalizations as $key => $value)
        {
            array_push($hospitalization_ids, $value->id);

            if (!in_array($value->patient_id, $pacient_ids))
            {
                array_push($pacient_ids, $value->patient_id);
                $data['total_pacientes']++;
            }
        }

        $bundle = $bundles_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'Bundles.hospitalization_id in ' => $hospitalization_ids,
                    'Bundles.created >' => $date_before,
                    'Bundles.created < ' => $date_after,
                ],
            ])->toArray();

        foreach ($bundle as $key => $value)
        {
            $data['total_bundles']++;
        }

// $nutrition_table        = TableRegistry::get('NutritionalAssessments');

// $hospital_result = $hospitalizations_table

//     ->find()

//     // ->select(['id'])

//     ->where(['Hospitalizations.unit_id =' => $unit_id])

//     ->toArray()

// ;

// //pega o id das internações separando por tipo

// foreach ($hospital_result as $key => $value) {

//     if ($value['type'] == "Clínica") {

//         $hospital_ids['clinica'][] = $value['id'];

//     }

//     if ($value['type'] == "Cirúrgica") {

//         $hospital_ids['cirurgica'][] = $value['id'];

//     }

//     $hospital_ids['geral'][] = $value['id'];

// }

// //cada tipo de internação(clinica, cirurgica)

// foreach ($hospital_ids as $type => $typeArr) {

//     $cont             = 0;

//     $nutrition[$type] = $nutrition_table

//         ->find()

//         ->where(['NutritionalAssessments.hospitalization_id IN' => $hospital_ids[$type]])

//         ->order(['NutritionalAssessments.created' => 'DESC'])

//         ->toArray()

//     ;

//     foreach ($nutrition[$type] as $key => $value) {

//         $cont++;

//         $arr[$type]['media_indice_nutricional'] += $value['nutric_score'];

//         //array_push($arr, $value);

//         //$arr[$type] = $value;

//         if ($value['nutric_score'] == 1) {

//             $evolution[$type] = $value['hospitalization_id'];

//         }

//     }

//     //checa se o infeliz evoluiu no quadro de nutric_score partindo do número 1

//     foreach ($nutrition[$type] as $key => $value) {

//         //como a função in_array não aceita arrays multidimensionais criei um

//         //array para receber o indice do array multidimensional

//         $dummyArrEvolution[] = $evolution[$type];

//         $dummyArrEvo[]       = $evo[$type];

//         if (

//             (in_array($value['hospitalization_id'], $dummyArrEvo) == false)

//             && (in_array($value['hospitalization_id'], $dummyArrEvolution))

//         ) {

//             if ($value['nutric_score'] > 1) {

//                 $arr[$type]['nutrition_evolution']++;

//                 $evo[$type][] = $value['hospitalization_id'];

//             }

//         }

//     }

//     //gera a media do indice(total / quantidade)

//     $arr[$type]['media_indice_nutricional'] = $arr[$type]['media_indice_nutricional'] / $cont;
        // }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório de cateter vesical.pdf',
            ],
        ]);

        $this->set('nutrition', 'arr');
    }

    public function supportiveMeasures()
    {
        //array suporte 1
        $suporte_procedimento_1 = ['Aminas hipertensoras', 'Balão intra-aórtico', 'Bioimpedância', 'Cateter arterial', 'Cateter de artéria pulmonar', 'Cateter de átrio esquerda', 'Cateter de mensuração da SjVO2', 'Cateter de microdiálise', 'Cateter de monitorização da pressão intracraniana', 'Cateter de PtiO2', 'Cateter venoso central curta permanência', 'Cateter venoso central longa permanência', 'Cateter venoso para diálise', 'Cateter venoso periférico', 'Cateter vesical', 'Derivação ventricular externa', 'Drogas hipotensoras em BI', 'Drogas inotrópicas em BI', 'ECMO', 'Macronebulização', 'Marcapasso transcutâneo', 'Marcapasso transvenoso', 'Monitoração hemodinâmica minimamente invasiva', 'Traqueostomia', 'Ventilação mecânica invasiva', 'Ventilação não-invasiva'];
        //array suporte 2
        $suporte_procedimento_2 = ['Abciximab', 'Albumina', 'Alteplase', 'Complemento', 'Complexo protrombínico', 'Concentrado de Fibrinogênio liofilizado', 'Concentrado de Hemácias', 'Concentrado de Plaquetas', 'Criopreciptado', 'Eptifibatide', 'Estreptoquinase', 'Fator IX', 'Fator VIIa', 'Fator VIII', 'Imunoglobulina', 'Plasma fresco', 'Tenecteplase', 'Tirofiban', 'Outros hemocomponentes'];

        $arr = [];
        $session = $this->request->session();
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');
        $unit_id = $session->read('selected-unit');
        //echo "unit_id = " . $unit_id;

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório de medidas de suporte.pdf',
            ],
        ]);

        $patients_table = TableRegistry::get('Patients');
        //Total de pacientes cadastrados
        $total_paciente = $patients = $patients_table->find()->count();

        $supportive_measures_table = TableRegistry::get('supportiveMeasures');
        //sql para buscar todo as medidas de suporte e procedimento
        $supportive_mesasure_patients = $supportive_measures_table->find('all', [
            'contain' => ['Hospitalizations' => ['Patients']],
            'conditions' => [
                'Hospitalizations.unit_id' => $unit_id,
                'supportiveMeasures.created >\'' . $date_before . '\' and supportiveMeasures.created < \'' . $date_after . '\'',
            ],
        ]);

        $arr2 = [];
        //cria o array, com o nome do procedimento e total de usuario de usaram o serviço
        $c = 0;

//$d = 0;
        foreach ($supportive_mesasure_patients as $key => $supportive_mesasure_patient)
        {
// verifica se pertence ao array de suporte 1 ou 2
            if (in_array($supportive_mesasure_patient['type'], $suporte_procedimento_1))
            {
                if (isset($supportive_mesasure_patient['data_inicio']) && isset($supportive_mesasure_patient['data_termino']))
                {
                    $d1 = explode("/", $supportive_mesasure_patient['data_inicio']);
                    $d2 = explode("/", $supportive_mesasure_patient['data_termino']);
                    $data1 = new \DateTime($d1['2'] . '-' . $d1['1'] . '-' . $d1['0']);
                    $data2 = new \DateTime($d2['2'] . '-' . $d2['1'] . '-' . $d2['0']);

                    $intervalo = $data1->diff($data2);

//echo "dias = " .$intervalo->d;

//total de dias e total de vezes que foi usado
                    if ($supportive_mesasure_patient['type'])
                    {
                        if (!isset($arr2[0][$supportive_mesasure_patient['type']]['totalDia']))
                        {
                            $arr2[0][$supportive_mesasure_patient['type']]['totalDia'] = $intervalo->d;
                            $arr2[0][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = 1;
                        }
                        else
                        {
                            $arr2[0][$supportive_mesasure_patient['type']]['totalDia'] = $arr2[0][$supportive_mesasure_patient['type']]['totalDia'] + $intervalo->d;
                            $arr2[0][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = $arr2[0][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] + 1;
                        }
                    }

//calculando minimo
                    if (!isset($arr2[0][$supportive_mesasure_patient['type']]['minimo']))
                    {
                        $arr2[0][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->d;
                    }
                    else
                    {
                        if ($arr2[0][$supportive_mesasure_patient['type']]['minimo'] > $intervalo->d)
                        {
                            $arr2[0][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->d;
                        }
                    }

//calculando maximo
                    if (!isset($arr2[0][$supportive_mesasure_patient['type']]['maximo']))
                    {
                        $arr2[0][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->d;
                    }
                    else
                    {
                        if ($arr2[0][$supportive_mesasure_patient['type']]['maximo'] < $intervalo->d)
                        {
                            $arr2[0][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->d;
                        }
                    }

                    //inserindo elementos no array para calcular a mediana
                    $arr2[0][$supportive_mesasure_patient['type']]['calcularMediana'][] = $intervalo->d;
                }

                $arr2[0][$supportive_mesasure_patient['type']]['nome'] = $supportive_mesasure_patient['type'];

                if (!isset($arr2[0][$supportive_mesasure_patient['type']]['ids']))
                {
                    $arr2[0][$supportive_mesasure_patient['type']]['ids'] = [];
                    array_push($arr2[0][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization']['patient']['id']);
                    $arr2[0][$supportive_mesasure_patient['type']]['total_paciente'] = 1;
                }
                else
                {

                    if (!in_array($supportive_mesasure_patient['hospitalization']['patient']['id'], $arr2[0][$supportive_mesasure_patient['type']]['ids']))
                    {
                        array_push($arr2[0][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization']['patient']['id']);
                        $arr2[0][$supportive_mesasure_patient['type']]['total_paciente'] = $arr2[0][$supportive_mesasure_patient['type']]['total_paciente'] + 1;
                    }
                }
            }
            else
            {

                if (isset($supportive_mesasure_patient['data_inicio']) && isset($supportive_mesasure_patient['data_termino']))
                {
                    $d1 = explode("/", $supportive_mesasure_patient['data_inicio']);
                    $d2 = explode("/", $supportive_mesasure_patient['data_termino']);
                    $data1 = new \DateTime($d1['2'] . '-' . $d1['1'] . '-' . $d1['0']);
                    $data2 = new \DateTime($d2['2'] . '-' . $d2['1'] . '-' . $d2['0']);

                    $intervalo = $data1->diff($data2);

//total de dias e total de vezes que foi usado
                    if ($supportive_mesasure_patient['type'])
                    {
                        if (!isset($arr2[1][$supportive_mesasure_patient['type']]['totalDia']))
                        {
                            $arr2[1][$supportive_mesasure_patient['type']]['totalDia'] = $intervalo->d;
                            $arr2[1][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = 1;
                        }
                        else
                        {
                            $arr2[1][$supportive_mesasure_patient['type']]['totalDia'] = $arr2[1][$supportive_mesasure_patient['type']]['totalDia'] + $intervalo->d;
                            $arr2[1][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = $arr2[1][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] + 1;
                        }
                    }

//calculando minimo
                    if (!isset($arr2[1][$supportive_mesasure_patient['type']]['minimo']))
                    {
                        $arr2[1][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->d;
                    }
                    else
                    {
                        if ($arr2[1][$supportive_mesasure_patient['type']]['minimo'] > $intervalo->d)
                        {
                            $arr2[1][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->d;
                        }
                    }

//calculando maximo
                    if (!isset($arr2[1][$supportive_mesasure_patient['type']]['maximo']))
                    {
                        $arr2[1][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->d;
                    }
                    else
                    {
                        if ($arr2[1][$supportive_mesasure_patient['type']]['maximo'] < $intervalo->d)
                        {
                            $arr2[1][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->d;
                        }
                    }

                    //inserindo elementos no array para calcular a mediana
                    $arr2[1][$supportive_mesasure_patient['type']]['calcularMediana'][] = $intervalo->d;
                }

                $arr2[1][$supportive_mesasure_patient['type']]['nome'] = $supportive_mesasure_patient['type'];

                if (!isset($arr2[1][$supportive_mesasure_patient['type']]['ids']))
                {
                    $arr2[1][$supportive_mesasure_patient['type']]['ids'] = [];
                    array_push($arr2[1][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization']['patient']['id']);
                    $arr2[1][$supportive_mesasure_patient['type']]['total_paciente'] = 1;
                }
                else
                {

                    if (!in_array($supportive_mesasure_patient['hospitalization']['patient']['id'], $arr2[1][$supportive_mesasure_patient['type']]['ids']))
                    {
                        array_push($arr2[1][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization']['patient']['id']);
                        $arr2[1][$supportive_mesasure_patient['type']]['total_paciente'] = $arr2[1][$supportive_mesasure_patient['type']]['total_paciente'] + 1;
                    }
                }
            }
        }

        $relatorios_table = TableRegistry::get('Relatorios');

        foreach ($arr2 as $key => $arr)
        {
            foreach ($arr as $key2 => $value)
            {
                //total de pacientes
                $percentual = ($value['total_paciente'] * 100) / $total_paciente;
                //total de parcientes em percentual
                $arr2[$key][$key2]['percentual'] = number_format($percentual, 2, '.', '');

                $diasI = $arr2[$key][$key2]['totalDia'] / $arr2[$key][$key2]['totalVezesUtilizou'];
                $cs = $diasI - (int) $diasI;

                if ($cs != 0)
                {
                    $cs = $cs * 24;
                    $arr2[$key][$key2]['totalMedia'] = floor($diasI) . " dias e " . $cs . "h";
                }
                else
                {

                    if ($diasI == 1)
                    {
                        //$arr2[$key][$key2]['totalMedia'] = floor($diasI) . " dia";
                        $arr2[$key][$key2]['totalMedia'] = floor($diasI);
                    }
                    else
                    {
                        //$arr2[$key][$key2]['totalMedia'] = floor($diasI) . " dias ";
                        $arr2[$key][$key2]['totalMedia'] = floor($diasI);
                    }
                }

                $arr2[$key][$key2]['mediana'] = $relatorios_table->mediana($arr2[$key][$key2]['calcularMediana']);
            }
        }

// echo "<pre>";

// print_r($arr2);

        foreach (array_merge($suporte_procedimento_1, $suporte_procedimento_2) as $key => $value)
        {
            if (!in_array($value, $arr2))
            {
                $dummyArray = [
                    $value => [
                        'totalDia' => 0,
                        'totalVezesUtilizou' => 0,
                        'minimo' => 0,
                        'maximo' => 0,
                        'mediana' => 0,
                        'totalMedia' => 0,
                        'percentual' => 0,

                    ],
                ];
                array_push($arr2, $dummyArray);
            }
        }

        $this->set('data', $arr2);
    }

    public function listarFuncionario()
    {
    }

    public function indicadoresUnidade()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Indicadores da unidade.pdf',
            ],
        ]);
    }

    public function indicadoresSetor()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Indicadores do setor.pdf',
            ],
        ]);
    }

    public function ccih()
    {
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');
        $hospitalization_ids = []; //array  com o id de todas as internações
        $infections = [];
        //$cultures = [];
        $data = [
            'hospital' => [
                'total_de_registros' => 0,

                'gravidade_percentual' => 0,
                'gravidade_total' => 0,
                'gravidade_sepse' => 0,
                'gravidade_infeccao' => 0,
                'gravidade_choque' => 0,

                'classificacao_comunitaria' => 0,
                'classificacao_nosocomial' => 0,
                'classificacao_nosocomial_de' => 0,
                'sem_identificacao' => 0,
                'classificacao_percentual' => 0,

                'comprovacao_microbiologica_total' => 0,
                'comprovacao_microbiologica_percentual' => 0,

                'gram_positivo_total' => 0,
                'gram_positivo_percentual' => 0,

                'tab_gravidade_tipo' => //tipo de infecção
                [
                    'infeccao' =>
                    [
                        'meningite' => 0, 'encefalite' => 0, 'meningoencefalite' => 0, 'sinusite' => 0, 'mastoidite' => 0, 'otite' => 0, 'celulite' => 0, 'amigdalite' => 0, 'laringite' => 0, 'traqueite' => 0, 'pneumonia' => 0, 'endocardite' => 0, 'infeccao_corrente' => 0, 'mediastinite' => 0, 'gastroenterite' => 0, 'hepatite' => 0, 'pancreatite' => 0, 'peritonite' => 0, 'infeccao_urinaria' => 0, 'infeccao_pelvica' => 0, 'piodermite' => 0, 'foliculite' => 0, 'fasciite' => 0, 'ulcera_infectada' => 0, 'abcesso' => 0, 'ostemielite' => 0, 'artrite_septica' => 0, 'tuberculose_pulmonar' => 0, 'herpes_zoster' => 0, 'outros' => 0,
                    ],
                    'sepse' =>
                    [
                        'meningite' => 0, 'encefalite' => 0, 'meningoencefalite' => 0, 'sinusite' => 0, 'mastoidite' => 0, 'otite' => 0, 'celulite' => 0, 'amigdalite' => 0, 'laringite' => 0, 'traqueite' => 0, 'pneumonia' => 0, 'endocardite' => 0, 'infeccao_corrente' => 0, 'mediastinite' => 0, 'gastroenterite' => 0, 'hepatite' => 0, 'pancreatite' => 0, 'peritonite' => 0, 'infeccao_urinaria' => 0, 'infeccao_pelvica' => 0, 'piodermite' => 0, 'foliculite' => 0, 'fasciite' => 0, 'ulcera_infectada' => 0, 'abcesso' => 0, 'ostemielite' => 0, 'artrite_septica' => 0, 'tuberculose_pulmonar' => 0, 'herpes_zoster' => 0, 'outros' => 0,
                    ],
                    'choque' =>
                    [
                        'meningite' => 0, 'encefalite' => 0, 'meningoencefalite' => 0, 'sinusite' => 0, 'mastoidite' => 0, 'otite' => 0, 'celulite' => 0, 'amigdalite' => 0, 'laringite' => 0, 'traqueite' => 0, 'pneumonia' => 0, 'endocardite' => 0, 'infeccao_corrente' => 0, 'mediastinite' => 0, 'gastroenterite' => 0, 'hepatite' => 0, 'pancreatite' => 0, 'peritonite' => 0, 'infeccao_urinaria' => 0, 'infeccao_pelvica' => 0, 'piodermite' => 0, 'foliculite' => 0, 'fasciite' => 0, 'ulcera_infectada' => 0, 'abcesso' => 0, 'ostemielite' => 0, 'artrite_septica' => 0, 'tuberculose_pulmonar' => 0, 'herpes_zoster' => 0, 'outros' => 0,
                    ],
                ],

                'comprovacao_microbiologica_sitio' =>
                [
                    'meningite' => 0, 'encefalite' => 0, 'meningoencefalite' => 0, 'sinusite' => 0, 'mastoidite' => 0, 'otite' => 0, 'celulite' => 0, 'amigdalite' => 0, 'laringite' => 0, 'traqueite' => 0, 'pneumonia' => 0, 'endocardite' => 0, 'infeccao_corrente' => 0, 'mediastinite' => 0, 'gastroenterite' => 0, 'hepatite' => 0, 'pancreatite' => 0, 'peritonite' => 0, 'infeccao_urinaria' => 0, 'infeccao_pelvica' => 0, 'piodermite' => 0, 'foliculite' => 0, 'fasciite' => 0, 'ulcera_infectada' => 0, 'abcesso' => 0, 'ostemielite' => 0, 'artrite_septica' => 0, 'tuberculose_pulmonar' => 0, 'herpes_zoster' => 0, 'outros' => 0,
                ],

                'comprovacao_microbiologica_gravidade' =>
                [
                    'infeccao' => 0,
                    'sepse' => 0,
                    'choque' => 0,
                ],

                'tipo_infeccao_gram_positivo' =>
                [
                    'meningite' => 0, 'encefalite' => 0, 'meningoencefalite' => 0, 'sinusite' => 0, 'mastoidite' => 0, 'otite' => 0, 'celulite' => 0, 'amigdalite' => 0, 'laringite' => 0, 'traqueite' => 0, 'pneumonia' => 0, 'endocardite' => 0, 'infeccao_corrente' => 0, 'mediastinite' => 0, 'gastroenterite' => 0, 'hepatite' => 0, 'pancreatite' => 0, 'peritsonite' => 0, 'infeccao_urinaria' => 0, 'infeccao_pelvica' => 0, 'piodermite' => 0, 'foliculite' => 0, 'fasciite' => 0, 'ulcera_infectada' => 0, 'abcesso' => 0, 'ostemielite' => 0, 'artrite_septica' => 0, 'tuberculose_pulmonar' => 0, 'herpes_zoster' => 0, 'outros' => 0,
                ],
            ],
        ];

        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $infections_table = TableRegistry::get('Infections');
        //$cultures_table = TableRegistry::get('Cultures');

        $hospitalizations = $hospitalizations_table
            ->find('all')
            ->where([
                'Hospitalizations.unit_id' => $unit_id,
                'Hospitalizations.created >\'' . $date_before . '\' and Hospitalizations.created < \'' . $date_after . '\'',
            ]);

        foreach ($hospitalizations as $key => $value)
        {
            array_push($hospitalization_ids, $value->id);
        }

        if (!empty($hospitalization_ids))
        {
            $infections = $infections_table->find('all', [
                'contain' => ["Cultures"],
                'conditions' => ['Infections.hospitalization_id in ' => $hospitalization_ids,
                ],
            ]);
        }

        foreach ($infections as $key => $infection)
        {
            $gravidade_infeccao = null;
            $data['hospital']['total_de_registros']++;

            if ($infection['gravity'] == 0) //GRAVIDADE DAS INFECÇÕES: INFECÇÃO, SEPSE E CHOQUE SÉPTICO NO HOSPITAL
            {
                $data['hospital']['gravidade_infeccao']++;
                $gravidade_infeccao = "infeccao";
            }
            elseif ($infection['gravity'] == 1)
            {
                $data['hospital']['gravidade_sepse']++;
                $gravidade_infeccao = "sepse";
            }
            elseif ($infection['gravity'] == 2)
            {
                $data['hospital']['gravidade_choque']++;
                $gravidade_infeccao = "choque";
            }

            if ($infection['classifcation'] == 0) //TIPO DE INFECÇÕES: COMUNITÁRIA, NOSOCOMIAL, NOSOCOMIAL OUTRA INSTITUIÇÃO OU SEM IDENTIFICAÇÃO NO HOSPITAL
            {
                $data['hospital']['classificacao_comunitaria']++;
            }
            elseif ($infection['classifcation'] == 1)
            {
                $data['hospital']['classificacao_nosocomial']++;
            }
            elseif ($infection['classifcation'] == 2)
            {
                $data['hospital']['classificacao_nosocomial_de']++;
            }
            elseif ($infection['classifcation'] == 3)
            {
                $data['hospital']['sem_identificacao']++;
            }

            if ($infection['identificacao_agente']) //COMPROVAÇÃO MICROBIOLÓGICA: VALOR ABSOLUTO E PERCENTUAL NO TOTAL DE INFECÇOES/SEPSES
            {
                $data['hospital']['comprovacao_microbiologica_total']++;

                foreach ($infection['cultures'] as $key2 => $culture)
                {
                    if ($culture['germe'] == 'Gram-positive cocci unspecified' || $culture['germe'] == 'Gram-positive rod unspecified')
                    {
                        $data['hospital']['gram_positivo_total']++; //GERME GRAM POSITIVO: VALOR ABSOLUTO E PERCENTUAL DE INCECÇÕES/SEPSES
                    }
                }

                switch ($gravidade_infeccao) //TABELA COMPROVAÇÃO MICROBIOLÓGICA POR GRAVIDADE DE INFECÇÒES
                {
                    case 'infeccao':
                        $data['hospital']['comprovacao_microbiologica_gravidade']['infeccao']++;
                        break;

                    case 'sepse':
                        $data['hospital']['comprovacao_microbiologica_gravidade']['sepse']++;
                        break;

                    case 'choque':
                        $data['hospital']['comprovacao_microbiologica_gravidade']['choque']++;
                        break;
                }

                switch ($infection['type']) //TABELA COMPROVAÇÃO MICROBIOLÓGICA POR SÍTIO/TIPO
                {
                    case 0:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['meningite']++;
                        break;
                    case 1:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['encefalite']++;
                        break;
                    case 2:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['meningoencefalite']++;
                        break;
                    case 3:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['sinusite']++;
                        break;
                    case 4:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['mastoidite']++;
                        break;
                    case 5:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['otite']++;
                        break;
                    case 6:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['celulite']++;
                        break;
                    case 7:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['amigdalite']++;
                        break;
                    case 8:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['laringite']++;
                        break;
                    case 9:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['traqueite']++;
                        break;
                    case 10:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['pneumonia']++;
                        break;
                    case 11:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['endocardite']++;
                        break;
                    case 12:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['infeccao_corrente']++;
                        break;
                    case 13:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['mediastinite']++;
                        break;
                    case 14:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['gastroenterite']++;
                        break;
                    case 15:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['hepatite']++;
                        break;
                    case 16:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['pancreatite']++;
                        break;
                    case 17:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['peritonite']++;
                        break;
                    case 18:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['infeccao_urinaria']++;
                        break;
                    case 19:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['infeccao_pelvica']++;
                        break;
                    case 20:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['piodermite']++;
                        break;
                    case 21:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['foliculite']++;
                        break;
                    case 22:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['fasciite']++;
                        break;
                    case 23:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['ulcera_infectada']++;
                        break;
                    case 24:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['abcesso']++;
                        break;
                    case 25:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['ostemielite']++;
                        break;
                    case 26:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['artrite_septica']++;
                        break;
                    case 27:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['tuberculose_pulmonar']++;
                        break;
                    case 28:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['herpes_zoster']++;
                        break;
                    case 29:
                        $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['outros']++;
                        break;
                }
            }

            switch ($infection['type']) //TABELA GRAVIDADE DE TIPO DE INFECÇÃO
            {
                case 0:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['meningite']++;
                    break;
                case 1:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['encefalite']++;
                    break;
                case 2:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['meningoencefalite']++;
                    break;
                case 3:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['sinusite']++;
                    break;
                case 4:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['mastoidite']++;
                    break;
                case 5:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['otite']++;
                    break;
                case 6:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['celulite']++;
                    break;
                case 7:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['amigdalite']++;
                    break;
                case 8:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['laringite']++;
                    break;
                case 9:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['traqueite']++;
                    break;
                case 10:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['pneumonia']++;
                    break;
                case 11:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['endocardite']++;
                    break;
                case 12:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['infeccao_corrente']++;
                    break;
                case 13:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['mediastinite']++;
                    break;
                case 14:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['gastroenterite']++;
                    break;
                case 15:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['hepatite']++;
                    break;
                case 16:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['pancreatite']++;
                    break;
                case 17:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['peritonite']++;
                    break;
                case 18:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['infeccao_urinaria']++;
                    break;
                case 19:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['infeccao_pelvica']++;
                    break;
                case 20:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['piodermite']++;
                    break;
                case 21:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['foliculite']++;
                    break;
                case 22:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['fasciite']++;
                    break;
                case 23:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['ulcera_infectada']++;
                    break;
                case 24:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['abcesso']++;
                    break;
                case 25:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['ostemielite']++;
                    break;
                case 26:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['artrite_septica']++;
                    break;
                case 27:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['tuberculose_pulmonar']++;
                    break;
                case 28:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['herpes_zoster']++;
                    break;
                case 29:
                    $data['hospital']['tab_gravidade_tipo'][$gravidade_infeccao]['outros']++;
                    break;
            }
        }

        $this->viewBuilder()->options(
            [
                'pdfConfig' =>
                [
                    'orientation' => 'portrait',
                    'filename' => 'Relatório CCIH.pdf',
                ],
            ]);

        $this->set('data', $data);
        $this->set('infections', $infections);
    }

    public function sihdot()
    {
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');

        $hospitalization_ids = [];
        $protocolos = null;
        $data = [
            'tot_paciente' => [],
            'tot_paciente_suspeita' => [],
            'percent_paciente_suspeita' => 0,
        ];

        $sihdot_table = TableRegistry::get('SuspectedMeProtocols');
        $hospitalizations_table = TableRegistry::get('Hospitalizations');

        $hospitalizations = $hospitalizations_table->find('all')
            ->contain(['Discharges'])
            ->where(['Hospitalizations.unit_id' => $unit_id]);

        foreach ($hospitalizations as $key => $value)
        {
            array_push($hospitalization_ids, $value->id);

            if (!isset($value->discharges[0]['data_saida_unidade']))
            {
                if (!in_array($value->id, $data['tot_paciente']))
                {
                    array_push($data['tot_paciente'], $value->id);
                }
            }

        }

        if (!empty($hospitalization_ids))
        {
            $protocolos = $sihdot_table->find('all',
                [
                    'contain' => ["Hospitalizations.Patients"],

                    'conditions' => [
                        'SuspectedMeProtocols.hospitalization_id IN' => $hospitalization_ids,
                        'SuspectedMeProtocols.created >\'' . $date_before . '\' and SuspectedMeProtocols.created < \'' . $date_after . '\'',
                    ],
                ]);

            foreach ($protocolos as $key => $protocol)
            {
                if (!in_array($protocol['hospitalization']['patient_id'], $data['tot_paciente_suspeita']))
                {
                    array_push($data['tot_paciente_suspeita'], $protocol['hospitalization']['patient_id']);
                }
            }
        }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório de CIHDOTT.pdf',
            ],
        ]);

        $protocolos->toArray();
        $this->set('protocolos', $protocolos);
        $this->set('hospitalizations', $hospitalizations);
        $this->set('data', $data);
    }

    public function bundlePav()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório Bundle de PAV.pdf',
            ],
        ]);
    }

    public function bundlePavDiario()
    {
        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório Bundle de PAV diario.pdf',
            ],
        ]);
    }

    public function visualizationEmergency()
    {

        $session = $this->request->session();
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');

        $screening_table = TableRegistry::get('Screenings');
        $screening = $screening_table->find('all', [
            'contain' => ["MedicalCares", "Admissions", 'Patients' => ['Diagnostics'], 'Professionals' => ["Users"]],

            'conditions' => ['Screenings.unit_id' => 1, 'Screenings.created >\'' . $date_before . '\' and Screenings.created < \'' . $date_after . '\''],
        ]);

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'landscape',
                'filename' => 'Visualizacao da emergencia.pdf',
            ],
        ]);
        $screening->toArray();
        $this->set('data', $screening);
    }

    public function visualizationHospitalization()
    {
        $session = $this->request->session();
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');

        $hospitalization_table = TableRegistry::get('Hospitalizations');
        $hospitalization = $hospitalization_table->find('all', [
            'contain' => ["IdentificationOfRisks", 'Patients', 'HistoricPatientMovements' => ['Rooms' => ['Sectors']], 'Diagnostics'],

            'conditions' => [
                'Hospitalizations.unit_id' => 1,
                'Hospitalizations.created >\'' . $date_before . '\' and Hospitalizations.created < \'' . $date_after . '\'',

            ],
        ]);

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'landscape',
                'filename' => 'Visualizacao dos pacientes na internacao.pdf',
            ],
        ]);
        $hospitalization->toArray();
        $this->set('data', $hospitalization);
    }

    public function resumoInternacao()
    {

        $hospitalization_table = TableRegistry::get('Hospitalizations');
        $hospitalization = $hospitalization_table->find('all', [
            'contain' => ["IdentificationOfRisks", 'Patients', 'HistoricPatientMovements' => ['Rooms' => ['Sectors']], 'Diagnostics' => ['Comorbidities']],

            'conditions' => ['Hospitalizations.id' => 2],
        ]

        )->first();

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Resumo da internação.pdf',
            ],
        ]);
        $hospitalization->toArray();
        $this->set('data', $hospitalization);
    }

    public function surgeries()
    {

        $session = $this->request->session();

//$date_before        = $session->read('date_before');
        //$date_after         = $session->read('date_after');
        $unit_id = $session->read('selected-unit');
        //$this->set('unit_id', $unit_id);
        $dataInicio = '2016-01-01';
        $dataFim = '2016-12-30';

//$dataInicio = $session->read('date_before');

//$dataFim = $session->read('date_after');
        //$hospitalization_id = $session->read('selected-hospitalization');

        $hospitalizations_table = TableRegistry::get('Hospitalizations');

        $hospitalizations = $hospitalizations_table->find('all')
            ->where(['Hospitalizations.unit_id' => $unit_id]);

        $hospitalization_ids = [];

        foreach ($hospitalizations as $key => $value)
        {
            array_push($hospitalization_ids, $value->id);
        }

        $surgeries_table = TableRegistry::get('Surgeries');
        /*$surgeries = $surgeries_table->find('all', [
        'contain'    => ['Hospitalizations'],
        'conditions'=>['Surgeries.data_da_cirurgia >\''.$dataInicio . '\' and Surgeries.data_da_cirurgia < \''. $dataFim .'\'']]
        );*/

        $surgeries = $surgeries_table->find('all', [
            'contain' => ['Rooms'],
            'conditions' => [
                'Surgeries.hospitalization_id in ' => $hospitalization_ids,
                'Surgeries.data_da_cirurgia >' => $dataInicio,
                'Surgeries.data_da_cirurgia <' => $dataFim,
            ],
        ]);

        $count = 0;
        $a = 0;
        $somatorioDias = 0;
        $countCirurgiaCadastroRealizado = 0;
        $somatorioDiasCicurgiaCadastroRealizado = 0;
        $arr = [];
        $taxaCancelamento = 0;
        $taxaAdiamento = 0;
        $countTaxaAtraso = 0;
        $countTaxaTerminoAtraso = 0;
        $tempoAtraso = 0;
        $tempoTerminoAtraso = 0;
        $tempoAtrasoCirurgia = 0;
        $countPortetempoAtrasoCirurgia = 0;
        $countConveniotempoAtrasoCirurgia = 0;
        $countTipoCirurgiatempoAtrasoCirurgia = 0;

        foreach ($surgeries as $key => $surgerie)
        {
// echo '<pre>';
            // var_dump($surgerie['hospitalization']);

            $data1 = $surgerie['data_da_solicitacao'];
            $data2 = $surgerie['data_da_liberacao'];
            $data_cirurgia = $surgerie['data_da_cirurgia'];

//echo "dd";
            if ($surgerie['data_da_cirurgia'] != "" && $surgerie['inicio_da_cirurgia_data'] != "")
            {
                $dataHoraAgendamentoCirurgia = new \DateTime($surgerie['data_da_cirurgia']->i18nFormat('yyyy-MM-dd') . ' ' . $surgerie['hora_da_cirurgia']->i18nFormat('HH:mm:ss'));
                $dataHoraInicioCirurgia = new \DateTime($surgerie['inicio_da_cirurgia_data']->i18nFormat('yyyy-MM-dd') . ' ' . $surgerie['inicio_da_cirurgia_hora']->i18nFormat('HH:mm:ss'));
                $dataHoraTerminoCirurgia = new \DateTime($surgerie['inicio_da_cirurgia_data']->i18nFormat('yyyy-MM-dd') . ' ' . $surgerie['termino_da_cirurgia_hora']->i18nFormat('HH:mm:ss'));

                $intervaloDataHoraCirugia = $dataHoraAgendamentoCirurgia->diff($dataHoraInicioCirurgia);
                $tempoAtrasoCirurgia = 0;
                if ($intervaloDataHoraCirugia->h > 0)
                {
                    $tempoAtrasoCirurgia = $intervaloDataHoraCirugia->h;
                    $tempoAtraso += $intervaloDataHoraCirugia->h;
                    $countTaxaAtraso++;
                }

//echo $surgerie['data_da_cirurgia']->i18nFormat('yyyy-MM-dd');
                //tempo que deve levar a cirurgia
                $tempo_de_cirurgia_estimado = explode(":", $surgerie['tempo_de_cirurgia_estimado']->i18nFormat('HH:mm:ss'));

                $somar = ' +' . $tempo_de_cirurgia_estimado[0] . ' hours, +' . $tempo_de_cirurgia_estimado[1] . ' minute';

//echo 'somar = ' . $somar;
                //hora de termino da cirurgia
                $dataHoraAgendamentoCirurgiaTermino = $dataHoraAgendamentoCirurgia->modify($somar);

                $dataHoraCirurgiaTermino = $dataHoraTerminoCirurgia->modify($somar);

                $intervaloDataHoraTerminoCirugia = $dataHoraCirurgiaTermino->diff($dataHoraAgendamentoCirurgiaTermino);

                $tempoAtrasoTerminoCirurgia = 0;

                if ($intervaloDataHoraTerminoCirugia->h > 0)
                {
                    $tempoAtrasoTerminoCirurgia = $intervaloDataHoraTerminoCirugia->h;
                    $tempoTerminoAtraso += $intervaloDataHoraTerminoCirugia->h;
                    $countTaxaTerminoAtraso++;
                }

                //print_r($dataHoraAgendamentoCirurgiaTermino);
            }

            if ($surgerie['cancelar_cirurgia'])
            {
                $taxaCancelamento++;
            }

            if ($surgerie['adiar_cirurgia'])
            {
                $taxaAdiamento++;
            }

//TEMPO MÉDIO DE CADASTRO DE CIRURGIA E LIBERAÇÃO DA CIRURGIA
            if ($data1 != "" && $data2 != "")
            {
                $intervalo = $data1->diff($data2);
                $somatorioDias += $intervalo->d;
                $count++;

//TEMPO MÉDIO DE CADASTRO DE CIRURGIA E LIBERAÇÃO DA CIRURGIA POR PORTE DE CIRURGIA

//$arr['porte'][$surgerie['porte_da_cirurgia']]['cancelamento'] = 0;
                if (!isset($arr['porte'][$surgerie['porte_da_cirurgia']]['totalDiasPorte']))
                {
                    $arr['porte'][$surgerie['porte_da_cirurgia']]['totalDiasPorte'] = $intervalo->d;
                    $arr['porte'][$surgerie['porte_da_cirurgia']]['countCirurgiaPorte'] = 1;
                    if ($surgerie['cancelar_cirurgia'])
                    {
                        $arr['porte'][$surgerie['porte_da_cirurgia']]['cancelamento'] = 1;
                    }
                    else
                    {
                        $arr['porte'][$surgerie['porte_da_cirurgia']]['cancelamento'] = 0;
                    }

                    if ($surgerie['adiar_cirurgia'])
                    {
                        $arr['porte'][$surgerie['porte_da_cirurgia']]['adiado'] = 1;
                    }
                    else
                    {
                        $arr['porte'][$surgerie['porte_da_cirurgia']]['adiado'] = 0;
                    }

                    if ($tempoAtrasoCirurgia > 0)
                    {
                        $arr['porte'][$surgerie['porte_da_cirurgia']]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                        $countPortetempoAtrasoCirurgia++;
                    }
                }
                else
                {
                    $arr['porte'][$surgerie['porte_da_cirurgia']]['totalDiasPorte'] += $intervalo->d;
                    $arr['porte'][$surgerie['porte_da_cirurgia']]['countCirurgiaPorte'] += 1;

                    if ($surgerie['cancelar_cirurgia'])
                    {
                        $arr['porte'][$surgerie['porte_da_cirurgia']]['cancelamento'] += 1;
                    }

                    if ($surgerie['adiar_cirurgia'])
                    {
                        $arr['porte'][$surgerie['porte_da_cirurgia']]['adiado'] += 1;
                    }

                    if ($tempoAtrasoCirurgia > 0)
                    {
                        if (!isset($arr['porte'][$surgerie['porte_da_cirurgia']]['tempoTotalAtrasoCirurgia']))
                        {
                            $arr['porte'][$surgerie['porte_da_cirurgia']]['tempoTotalAtrasoCirurgia'] += $tempoAtrasoCirurgia;
                            $countPortetempoAtrasoCirurgia++;
                        }
                        else
                        {
                            $arr['porte'][$surgerie['porte_da_cirurgia']]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                            $countPortetempoAtrasoCirurgia++;
                        }
                    }
                }

//TEMPO MÉDIO DE CADASTRO DE CIRURGIA E LIBERAÇÃO DA CIRURGIA POR TIPO DE CIRURGIA

//$arr['tipoCirurgia'][$surgerie['nome']]['cancelamento'] = 0;
                if (!isset($arr['tipoCirurgia'][$surgerie['nome']]['countTipoCirurgia']))
                {
                    $arr['tipoCirurgia'][$surgerie['nome']]['nome'] = $surgerie['nome'];
                    $arr['tipoCirurgia'][$surgerie['nome']]['countTipoCirurgia'] = 1;
                    $arr['tipoCirurgia'][$surgerie['nome']]['totalDiasTipo'] = $intervalo->d;

//taxa cancelamento
                    if ($surgerie['cancelar_cirurgia'])
                    {
                        $arr['tipoCirurgia'][$surgerie['nome']]['cancelamento'] = 1;
                    }
                    else
                    {
                        $arr['tipoCirurgia'][$surgerie['nome']]['cancelamento'] = 0;
                    }

//taxa adiamento
                    if ($surgerie['adiar_cirurgia'])
                    {
                        $arr['tipoCirurgia'][$surgerie['nome']]['adiado'] = 1;
                    }
                    else
                    {
                        $arr['tipoCirurgia'][$surgerie['nome']]['adiado'] = 0;
                    }

                    if ($tempoAtrasoCirurgia > 0)
                    {
                        $arr['tipoCirurgia'][$surgerie['nome']]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                        $countTipoCirurgiatempoAtrasoCirurgia++;
                    }
                }
                else
                {
                    $arr['tipoCirurgia'][$surgerie['nome']]['countTipoCirurgia'] += 1;
                    $arr['tipoCirurgia'][$surgerie['nome']]['totalDiasTipo'] += $intervalo->d;

                    if ($surgerie['cancelar_cirurgia'])
                    {
                        $arr['tipoCirurgia'][$surgerie['nome']]['cancelamento'] += 1;
                    }

                    if ($surgerie['adiar_cirurgia'])
                    {
                        $arr['tipoCirurgia'][$surgerie['nome']]['adiado'] += 1;
                    }

                    if ($tempoAtrasoCirurgia > 0)
                    {
                        if (!isset($arr['tipoCirurgia'][$surgerie['nome']]['tempoTotalAtrasoCirurgia']))
                        {
                            $arr['tipoCirurgia'][$surgerie['nome']]['tempoTotalAtrasoCirurgia'] += $tempoAtrasoCirurgia;
                            $countTipoCirurgiatempoAtrasoCirurgia++;
                        }
                        else
                        {
                            $arr['tipoCirurgia'][$surgerie['nome']]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                            $countTipoCirurgiatempoAtrasoCirurgia++;
                        }
                    }
                }

                if (!isset($arr['convenio'][$surgerie['hospitalization']['complementary_health']]['countConvenio']))
                {
                    $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['nome'] = $surgerie['hospitalization']['complementary_health'];

                    $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['countConvenio'] = 1;
                    $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['totalDiasConvenio'] = $intervalo->d;

                    if ($surgerie['cancelar_cirurgia'])
                    {
                        $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['cancelamento'] = 1;
                    }
                    else
                    {
                        $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['cancelamento'] = 0;
                    }

                    if ($surgerie['adiar_cirurgia'])
                    {
                        $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['adiado'] = 1;
                    }
                    else
                    {
                        $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['adiado'] = 0;
                    }

                    if ($tempoAtrasoCirurgia > 0)
                    {
                        $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                        $countConveniotempoAtrasoCirurgia++;
                    }
                }
                else
                {
                    $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['countConvenio'] += 1;
                    $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['totalDiasConvenio'] += $intervalo->d;

                    if ($surgerie['cancelar_cirurgia'])
                    {
                        $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['cancelamento'] += 1;
                    }

                    if ($surgerie['adiar_cirurgia'])
                    {
                        $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['adiado'] += 1;
                    }

                    if ($tempoAtrasoCirurgia > 0)
                    {
                        if (!isset($arr['convenio'][$surgerie['hospitalization']['complementary_health']]['tempoTotalAtrasoCirurgia']))
                        {
                            $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['tempoTotalAtrasoCirurgia'] += $tempoAtrasoCirurgia;
                            $countConveniotempoAtrasoCirurgia++;
                        }
                        else
                        {
                            $arr['convenio'][$surgerie['hospitalization']['complementary_health']]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                            $countConveniotempoAtrasoCirurgia++;
                        }
                    }
                }

//TEMPO MÉDIO DE ATRASO DE CIRURGIA POR SALA CIRURGICA
                if ($tempoAtrasoCirurgia > 0 && $surgerie['room']['id'] != null)
                {
                    if (!isset($arr['tempoAtrasoSalaCirurgica'][$surgerie['room']['id']]['countSala']))
                    {
                        $arr['tempoAtrasoSalaCirurgica'][$surgerie['room']['id']]['nome'] = $surgerie['room']['name'];
                        $arr['tempoAtrasoSalaCirurgica'][$surgerie['room']['id']]['countSala'] = 1;
                        $arr['tempoAtrasoSalaCirurgica'][$surgerie['room']['id']]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                    }
                    else
                    {
                        $arr['tempoAtrasoSalaCirurgica'][$surgerie['room']['id']]['countSala'] = +1;
                        $arr['tempoAtrasoSalaCirurgica'][$surgerie['room']['id']]['tempoTotalAtrasoCirurgia'] += $tempoAtrasoCirurgia;
                    }
                }

                if ($tempoAtrasoCirurgia > 0)
                {
                    //TEMPO MÉDIO DE ATRASO DE CIRURGIA POR DIA DA SEMANA
                    $diaSemana = $surgeries_table->diaSemana($surgerie['data_da_cirurgia']->i18nFormat('yyyy-MM-dd'));

                    if (!isset($arr['diaDeSemana'][$diaSemana]['diaSemana']))
                    {
                        $arr['diaDeSemana'][$diaSemana]['diaSemana'] = $diaSemana;
                        $arr['diaDeSemana'][$diaSemana]['countDiaSemana'] = 1;
                        $arr['diaDeSemana'][$diaSemana]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                    }
                    else
                    {
                        $arr['diaDeSemana'][$diaSemana]['countDiaSemana'] += 1;
                        $arr['diaDeSemana'][$diaSemana]['tempoTotalAtrasoCirurgia'] += $tempoAtrasoCirurgia;
                    }

//TEMPO MÉDIO DE ATRASO DE CIRURGIA POR TIPO ROTINA, URGENTE E EMERGENTE
                    if (!isset($arr['caracteristica_da_cirurgia'][$surgerie['caracteristica_da_cirurgia']]['tipo']))
                    {
                        $arr['caracteristica_da_cirurgia'][$surgerie['caracteristica_da_cirurgia']]['tipo'] = $surgerie['caracteristica_da_cirurgia'];
                        $arr['caracteristica_da_cirurgia'][$surgerie['caracteristica_da_cirurgia']]['countTipo'] = 1;
                        $arr['caracteristica_da_cirurgia'][$surgerie['caracteristica_da_cirurgia']]['tempoTotalAtrasoCirurgia'] = $tempoAtrasoCirurgia;
                    }
                    else
                    {
                        $arr['caracteristica_da_cirurgia'][$surgerie['caracteristica_da_cirurgia']]['countTipo'] += 1;
                        $arr['caracteristica_da_cirurgia'][$surgerie['caracteristica_da_cirurgia']]['tempoTotalAtrasoCirurgia'] += $tempoAtrasoCirurgia;
                    }
                }
            }

            if ($data1 != "" && $data_cirurgia != "")
            {
                $intervalo = $data1->diff($data_cirurgia);
                $somatorioDiasCicurgiaCadastroRealizado += $intervalo->d;
                $countCirurgiaCadastroRealizado++;
                if (!isset($arr['cirurgia_cadastro_realizado']['totalDias']))
                {
                    $arr['cirurgia_cadastro_realizado']['totalDias'] = $intervalo->d;
                    $arr['cirurgia_cadastro_realizado']['countCirurgiaCadastroRealizado'] = 1;
                }
                else
                {
                    $arr['cirurgia_cadastro_realizado']['totalDias'] += $intervalo->d;
                    $arr['cirurgia_cadastro_realizado']['countCirurgiaCadastroRealizado'] += 1;
                }

//echo $surgerie['nome']."<br>";
                if (!isset($arr['cirurgia_cadastro_realizado']['tipoCirurgia'][$surgerie['nome']]['countTipoCirurgia']))
                {
                    $arr['cirurgia_cadastro_realizado']['tipoCirurgia'][$surgerie['nome']]['nome'] = $surgerie['nome'];
                    $arr['cirurgia_cadastro_realizado']['tipoCirurgia'][$surgerie['nome']]['countTipoCirurgia'] = 1;
                    $arr['cirurgia_cadastro_realizado']['tipoCirurgia'][$surgerie['nome']]['totalDiasTipo'] = $intervalo->d;
                }
                else
                {
                    $arr['cirurgia_cadastro_realizado']['tipoCirurgia'][$surgerie['nome']]['countTipoCirurgia'] += 1;
                    $arr['cirurgia_cadastro_realizado']['tipoCirurgia'][$surgerie['nome']]['totalDiasTipo'] += $intervalo->d;
                }

                if (!isset($arr['cirurgia_cadastro_realizado']['porte'][$surgerie['porte_da_cirurgia']]['totalDiasPorte']))
                {
                    $arr['cirurgia_cadastro_realizado']['porte'][$surgerie['porte_da_cirurgia']]['totalDiasPorte'] = $intervalo->d;
                    $arr['cirurgia_cadastro_realizado']['porte'][$surgerie['porte_da_cirurgia']]['countCirurgiaPorte'] = 1;
                }
                else
                {
                    $arr['cirurgia_cadastro_realizado']['porte'][$surgerie['porte_da_cirurgia']]['totalDiasPorte'] += $intervalo->d;
                    $arr['cirurgia_cadastro_realizado']['porte'][$surgerie['porte_da_cirurgia']]['countCirurgiaPorte'] += 1;
                }

                if (!isset($arr['cirurgia_cadastro_realizado']['convenio'][$surgerie['hospitalization']['complementary_health']]['countConvenio']))
                {
                    //echo $a++;
                    $arr['cirurgia_cadastro_realizado']['convenio'][$surgerie['hospitalization']['complementary_health']]['nome'] = $surgerie['hospitalization']['complementary_health'];

                    $arr['cirurgia_cadastro_realizado']['convenio'][$surgerie['hospitalization']['complementary_health']]['countConvenio'] = 1;
                    $arr['cirurgia_cadastro_realizado']['convenio'][$surgerie['hospitalization']['complementary_health']]['totalDiasConvenio'] = $intervalo->d;
                }
                else
                {
                    $arr['cirurgia_cadastro_realizado']['convenio'][$surgerie['hospitalization']['complementary_health']]['countConvenio'] += 1;
                    $arr['cirurgia_cadastro_realizado']['convenio'][$surgerie['hospitalization']['complementary_health']]['totalDiasConvenio'] += $intervalo->d;
                }
            }
        }

        foreach ($arr['porte'] as $key => $porte)
        {
            $somatorioDiasP = $porte['totalDiasPorte'];
            $countDiasP = $porte['countCirurgiaPorte'];
            $mediaP = $somatorioDiasP / $countDiasP;
            $arr['porte'][$key]['mediaDiasPorte'] = number_format($mediaP, 2, '.', '');

            $somatorioAtrasoCirurgia = $porte['tempoTotalAtrasoCirurgia'];
            $arr['porte'][$key]['tempoTotalAtrasoCirurgia'] = $porte['tempoTotalAtrasoCirurgia'] . 'h';
            $arr['porte'][$key]['countPorteTempoAtrasoCirurgia'] = $countPortetempoAtrasoCirurgia;
            $arr['porte'][$key]['tempoMedioAtrasoCirurgia'] = ($somatorioAtrasoCirurgia / $countPortetempoAtrasoCirurgia) . 'h';
            //$arr['porte'][$key]['countAtrasoCirurgiaMedia'] = $countPortetempoAtrasoCirurgia;
        }

        foreach ($arr['tipoCirurgia'] as $key => $tipo)
        {
            $totalDiasTipo = $tipo['totalDiasTipo'];
            $countDiasT = $tipo['countTipoCirurgia'];
            $mediaT = $totalDiasTipo / $countDiasT;
            $arr['tipoCirurgia'][$key]['mediaTotalDiasTipo'] = number_format($mediaT, 2, '.', '');

            $somatorioAtrasoCirurgia = $tipo['tempoTotalAtrasoCirurgia'];
            $arr['tipoCirurgia'][$key]['tempoTotalAtrasoCirurgia'] = $tipo['tempoTotalAtrasoCirurgia'] . 'h';
            $arr['tipoCirurgia'][$key]['countPorteTempoAtrasoCirurgia'] = $countTipoCirurgiatempoAtrasoCirurgia;
            $arr['tipoCirurgia'][$key]['tempoMedioAtrasoCirurgia'] = ($somatorioAtrasoCirurgia / $countTipoCirurgiatempoAtrasoCirurgia) . 'h';
        }

        foreach ($arr['convenio'] as $key => $convenio)
        {
            $totalDiasConvenio = $convenio['totalDiasConvenio'];
            $countDiasConvenio = $convenio['countConvenio'];
            $mediaP = $totalDiasConvenio / $countDiasConvenio;
            $arr['convenio'][$key]['mediaTotalDiasConvenio'] = number_format($mediaP, 2, '.', '');

            $somatorioAtrasoCirurgia = $convenio['tempoTotalAtrasoCirurgia'];
            $arr['convenio'][$key]['tempoTotalAtrasoCirurgia'] = $convenio['tempoTotalAtrasoCirurgia'] . 'h';
            $arr['convenio'][$key]['countPortetempoAtrasoCirurgia'] = $countPortetempoAtrasoCirurgia;
            $arr['convenio'][$key]['tempoMedioAtrasoCirurgia'] = ($somatorioAtrasoCirurgia / $countPortetempoAtrasoCirurgia) . 'h';
        }

        foreach ($arr['cirurgia_cadastro_realizado']['tipoCirurgia'] as $key => $tipo)
        {
            $totalDiasTipo = $tipo['totalDiasTipo'];
            $countDiasT = $tipo['countTipoCirurgia'];
            $mediaT = $totalDiasTipo / $countDiasT;
            $arr['cirurgia_cadastro_realizado']['tipoCirurgia'][$key]['media'] = number_format($mediaT, 2, '.', '');
        }

        foreach ($arr['cirurgia_cadastro_realizado']['porte'] as $key => $porte)
        {
            $somatorioDiasP = $porte['totalDiasPorte'];
            $countDiasP = $porte['countCirurgiaPorte'];
            $mediaP = $somatorioDiasP / $countDiasP;
            $arr['cirurgia_cadastro_realizado']['porte'][$key]['media'] = number_format($mediaP, 2, '.', '');
        }

        foreach ($arr['cirurgia_cadastro_realizado']['convenio'] as $key => $convenio)
        {
            $somatorioDiasConvenio = $convenio['totalDiasConvenio'];
            $countDiasConvenio = $convenio['countConvenio'];
            $mediaP = $somatorioDiasConvenio / $countDiasConvenio;
            $arr['cirurgia_cadastro_realizado']['convenio'][$key]['media'] = number_format($mediaP, 2, '.', '');
        }

        foreach ($arr['tempoAtrasoSalaCirurgica'] as $key => $salaCirurgica)
        {
            $somatorioAtrasoCirurgia = $salaCirurgica['tempoTotalAtrasoCirurgia'];
            $countSala = $salaCirurgica['countSala'];
            $mediaP = $somatorioAtrasoCirurgia / $countSala;
            $arr['tempoAtrasoSalaCirurgica'][$key]['media'] = number_format($mediaP, 2, '.', '');
        }

        foreach ($arr['diaDeSemana'] as $key => $diaSemana)
        {
            $somatorioAtrasoDiaSemana = $diaSemana['tempoTotalAtrasoCirurgia'];
            $countDiaSemana = $diaSemana['countDiaSemana'];
            $mediaP = $somatorioAtrasoDiaSemana / $countDiaSemana;
            $arr['diaDeSemana'][$key]['media'] = number_format($mediaP, 2, '.', '');
        }

        foreach ($arr['caracteristica_da_cirurgia'] as $key => $caracteristica_da_cirurgia)
        {
            $somatorioAtrasoCaracteristicaCirurgia = $caracteristica_da_cirurgia['tempoTotalAtrasoCirurgia'];
            $countTipo = $caracteristica_da_cirurgia['countTipo'];
            $mediaP = $somatorioAtrasoCaracteristicaCirurgia / $countTipo;
            $arr['caracteristica_da_cirurgia'][$key]['media'] = number_format($mediaP, 2, '.', '');
        }

//$arr['taxaLiberaçãoSala']['tempoTerminoAtraso'] = $tempoTerminoAtraso;

//$arr['taxaLiberaçãoSala']['countTaxaTerminoAtraso'] = $countTaxaTerminoAtraso;
        //$tempoTerminoAtraso += $intervaloDataHoraTerminoCirugia->h;

        $arr['totalDias'] = $somatorioDias;
        $arr['totalCirurgia'] = $count;
        $media = $somatorioDias / $count;
        $media_cirurgia_cadastro_realizado = $somatorioDiasCicurgiaCadastroRealizado / $countCirurgiaCadastroRealizado;
        $arr['totalTempoMedia'] = number_format($media, 2, '.', '');
        $arr['cirurgia_cadastro_realizado']['totalTempoMedia'] = number_format($media_cirurgia_cadastro_realizado, 2, '.', '');
        $arr['taxaCancelamentoCirurgia'] = $taxaCancelamento;
        $arr['taxaAdiamentoCirurgia'] = $taxaAdiamento;
        $arr['tempoTotalAtrasoCirurgia'] = $tempoAtraso . 'h';
        $arr['countTaxaAtrasoCirurgia'] = $countTaxaAtraso;

        $tempoMedioAtrasoCirurgia = $tempoAtraso / $countTaxaAtraso;
        $arr['tempoMedioAtrasoCirurgia'] = $tempoMedioAtrasoCirurgia . 'h';
        echo "<pre>";
        print_r($arr);
        $this->set('surgeries', $surgeries);
    }

    public function neonatal()
    {
        $data = null;
        $session = $this->request->session();

// $date_before = $session->read('date_before');
        // $date_after  = $session->read('date_after');
        $unit_id = $session->read('selected-unit');
        $neonatal_table = TableRegistry::get('NeonatalChecklists');
        $hospitalization_table = TableRegistry::get('Hospitalizations');
        $hospitalizations = $hospitalization_table->find('all', [
            'contain' => ["NeonatalChecklists"],

            'conditions' => [
                'Hospitalizations.unit_id' => $unit_id,
                //'Hospitalizations.created >\'' . $date_before . '\' and Hospitalizations.created < \'' . $date_after . '\'',
            ],
        ]
        )->toArray();
        $data = $neonatal_table->relatorioNeonatal($hospitalizations);

// foreach ($hospitalizations as $hospitalization) {

//     //$data = $hospitalization["neonatal_checklists"];

//     foreach ($hospitalization["neonatal_checklists"] as $key => $neonatal) {

//         //$netonatal['paridade']

//         if ($neonatal['paridade']) {

//             if (isset($data[$neonatal['id']]["paridade"])) {

//                 $data[$neonatal['id']]["paridade"]++;

//             } else {

//                 $data[$neonatal['id']]["paridade"] = 1;

//             }

//         }

//         if ($neonatal['paridade']) {

//             if (isset($data[$neonatal['id']]["paridade"])) {

//                 $data[$neonatal['id']]["paridade"]++;

//             } else {

//                 $data[$neonatal['id']]["paridade"] = 1;

//             }

//         }

//     }
        // }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório neonatal.pdf',
            ],
        ]);
        //$hospitalization->toArray();
        $this->set('hospitalizations', $hospitalizations);
        $this->set('data', $data);
    }

    public function escores()
    {
        $data = null;
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');
        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $curb_scores_table = TableRegistry::get('CurbScores');
        $sofa_scores_table = TableRegistry::get('SofaEscores');
        $pre_deliric_scores_table = TableRegistry::get('PreDeliricScores');
        $crib_scores_table = TableRegistry::get('CribScores');
        $nas_scores_table = TableRegistry::get('NasScores');
        $apache_ii_scores_table = TableRegistry::get('ApacheIiScores');
        $snap_ii_scores_table = TableRegistry::get('SnapIiScores');
        $saps_iii_scores_table = TableRegistry::get('SapsIiiScores');

        $data = [
            'total_pacientes' => 0,
            'pre_deliric' => [
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'media_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'desvio_padrao' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
            ],
            'sofa' => [
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'media_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'desvio_padrao' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
            ],
            'curb' => [
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'media_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'desvio_padrao' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
                'total_superior_3' => 0,
                'percentual_superior_3' => 0,
                'total_superior_4' => 0,
                'percentual_superior_4' => 0,

            ],
            'crib' => [
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'media_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'desvio_padrao' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
            ],
            'nas' => [
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'media_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'desvio_padrao' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
            ],
            'apache' => [
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'media_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'desvio_padrao' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
            ],
            'snap' => [
                'total_pacientes' => 0,
                'percentual_pacientes' => 0,
                'total_score' => 0,
                'media_score' => 0,
                'minimo_score' => 0,
                'maximo_score' => 0,
                'desvio_padrao' => 0,
                'total_superior_2' => 0,
                'percentual_superior_2' => 0,
            ],
        ];
        $arr_global = [];
        $hospitalization_ids = [];
        $pacient_ids = [
            'total' => [],
            'curb' => [],
            'sofa' => [],
            'pre_deliric' => [],
            'crib' => [],
            'nas' => [],
            'apache' => [],
            'snap' => [],

        ];

        $hospitalizations = $hospitalizations_table->find('all',
            ['conditions' => ['Hospitalizations.unit_id' => $unit_id],
            ]);

        foreach ($hospitalizations as $key => $value)
        {
            array_push($hospitalization_ids, $value->id);

            if (!in_array($value->patient_id, $pacient_ids['total']))
            {
                array_push($pacient_ids['total'], $value->patient_id);
                $data['total_pacientes']++;
            }
        }

        $curb = $curb_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'CurbScores.hospitalization_id in ' => $hospitalization_ids,
                    'CurbScores.created >' => $date_before,
                    'CurbScores.created < ' => $date_after,
                ],
            ])->toArray();

        $sofa = $sofa_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'SofaEscores.hospitalization_id in ' => $hospitalization_ids,
                    'SofaEscores.created >' => $date_before,
                    'SofaEscores.created < ' => $date_after,
                ],
            ])->toArray();

        $pre_deliric = $pre_deliric_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'PreDeliricScores.hospitalization_id in ' => $hospitalization_ids,
                    'PreDeliricScores.created >' => $date_before,
                    'PreDeliricScores.created < ' => $date_after,
                ],
            ])->toArray();

        $crib = $crib_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'CribScores.hospitalization_id in ' => $hospitalization_ids,
                    'CribScores.created >' => $date_before,
                    'CribScores.created < ' => $date_after,
                ],
            ])->toArray();

        $nas = $nas_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'NasScores.hospitalization_id in ' => $hospitalization_ids,
                    'NasScores.created >' => $date_before,
                    'NasScores.created < ' => $date_after,
                ],
            ])->toArray();

        $apache = $apache_ii_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'ApacheIiScores.hospitalization_id in ' => $hospitalization_ids,
                    'ApacheIiScores.created >' => $date_before,
                    'ApacheIiScores.created < ' => $date_after,
                ],
            ])->toArray();

        $snap = $snap_ii_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'SnapIiScores.hospitalization_id in ' => $hospitalization_ids,
                    'SnapIiScores.created >' => $date_before,
                    'SnapIiScores.created < ' => $date_after,
                ],
            ])->toArray();

        $saps = $saps_iii_scores_table
            ->find('all', [
                'contain' => ['Hospitalizations'],
                'conditions' =>
                [
                    'SapsIiiScores.hospitalization_id in ' => $hospitalization_ids,
                    'SapsIiiScores.created >' => $date_before,
                    'SapsIiiScores.created < ' => $date_after,
                ],
            ])->toArray();

        $arr_global['sofa'] = $sofa;
        $arr_global['curb'] = $curb;
        $arr_global['pre_deliric'] = $pre_deliric;
        $arr_global['crib'] = $crib;
        $arr_global['nas'] = $nas;
        $arr_global['apache'] = $apache;
        $arr_global['snap'] = $snap;
        $arr_global['saps'] = $saps;

        foreach ($arr_global as $key_global => $value_global)
        {
            if (!is_array($value_global))
            {
                return;
            }

            $total_score = 0;
            $count = 0;
            $len = count($value_global);

            foreach ($value_global as $key => $value)
            {
                if ($value->pontuation)
                {
                    $total_score += $value->pontuation;

                    if ($value->pontuation < $data[$key_global]['minimo_score'])
                    {
                        $data[$key_global]['minimo_score'] = $value->pontuation;
                    }

                    if ($value->pontuation > $data[$key_global]['maximo_score'])
                    {
                        $data[$key_global]['maximo_score'] = $value->pontuation;
                    }
                }

                if (!in_array($value->hospitalization->patient_id, $pacient_ids[$key_global]))
                {
                    array_push($pacient_ids[$key_global], $value->hospitalization->patient_id);
                    $data[$key_global]['total_pacientes']++;
                }

                if ($count == $len - 1)
                {
// last
                    if ($total_score > 0 && $count > 0)
                    {
                        $data[$key_global]['media_score'] = $total_score / $count;
                    }

                    //$data['curb']['total_score'] = $total_score;
                }

                $count++;
            }
        }

//curb

// $curb = $curb_scores_table

//     ->find('all', [

//         'contain'    => ['Hospitalizations'],

//         'conditions' =>

//         [

//             'CurbScores.hospitalization_id in ' => $hospitalization_ids,

//             'CurbScores.created >'              => $date_before,

//             'CurbScores.created < '             => $date_after,

//         ],

//     ])->toArray();

// $count_curb = 0;

// $len        = count($curb);

// foreach ($curb as $key => $value) {

//     $total_score = 0;

//     $total_superior_2 = 0;

//     $total_superior_3 = 0;

//     $total_superior_4 = 0;

//     if ($value->pontuation) {

//         $total_score += $value->pontuation;

//         if ($value->pontuation < $data['curb']['minimo_score']) {

//             $data['curb']['minimo_score'] = $value->pontuation;

//         }

//         if ($value->pontuation > $data['curb']['maximo_score']) {

//             $data['curb']['maximo_score'] = $value->pontuation;

//         }

//         if ($value->pontuation > 4) {

//             $total_superior_4++;

//         } else if ($value->pontuation > 3) {

//             $total_superior_3++;

//         } else if ($value->pontuation > 2) {

//             $total_superior_2++;

//         }

//     }

//     if (!in_array($value->hospitalization->patient_id, $pacient_ids['curb'])) {

//         array_push($pacient_ids['curb'], $value->hospitalization->patient_id);

//         $data['curb']['total_pacientes']++;

//     }

//     if ($count_curb == $len - 1) {

//         // last

//         $data['curb']['media_score'] = $total_score / $count_curb;

//         //$data['curb']['total_score'] = $total_score;

//         if ($count_curb > 0) {

//             if ($total_superior_2 > 0) {

//                 $data['curb']['total_superior_2']      = $total_superior_2;

//                 $data['curb']['percentual_superior_2'] = ($total_superior_2 / $count_curb) * 100;

//             }

//             if ($total_superior_3 > 0) {

//                 $data['curb']['total_superior_3']      = $total_superior_3;

//                 $data['curb']['percentual_superior_3'] = ($total_superior_3 / $count_curb) * 100;

//             }

//             if ($total_superior_4 > 0) {

//                 $data['curb']['total_superior_4']      = $total_superior_4;

//                 $data['curb']['percentual_superior_4'] = ($total_superior_4 / $count_curb) * 100;

//             }

//         }

//     }

//     $count_curb++;

// }

//sofa

// $len        = count($sofa);

// $count_sofa = 0;

// $sofa       = $sofa_scores_table

//     ->find('all', [

//         'contain'    => ['Hospitalizations'],

//         'conditions' =>

//         [

//             'SofaEscores.hospitalization_id in ' => $hospitalization_ids,

//             'SofaEscores.created >'              => $date_before,

//             'SofaEscores.created < '             => $date_after,

//         ],

//     ])->toArray();

// foreach ($sofa as $key => $value) {

//     $total_score      = 0;

//     $total_superior_2 = 0;

//     if ($value->pontuation) {

//         $total_score += $value->pontuation;

//         if ($value->pontuation < $data['sofa']['minimo_score']) {

//             $data['sofa']['minimo_score'] = $value->pontuation;

//         }

//         if ($value->pontuation > $data['sofa']['maximo_score']) {

//             $data['sofa']['maximo_score'] = $value->pontuation;

//         }

//         if ($value->pontuation > 4) {

//             $total_superior_4++;

//         } else if ($value->pontuation > 3) {

//             $total_superior_3++;

//         } else if ($value->pontuation > 2) {

//             $total_superior_2++;

//         }

//     }

//     if (!in_array($value->hospitalization->patient_id, $pacient_ids['sofa'])) {

//         array_push($pacient_ids['sofa'], $value->hospitalization->patient_id);

//         $data['sofa']['total_pacientes']++;

//     }

//     if ($count_sofa == $len - 1) {

//         // last

//         $data['sofa']['media_score'] = $total_score / $count_sofa;

//         //$data['curb']['total_score'] = $total_score;

//         if ($count_sofa > 0) {

//             if ($total_superior_2 >= 0) {

//                 $data['sofa']['total_superior_2']      = $total_superior_2;

//                 $data['sofa']['percentual_superior_2'] = ($total_superior_2 / $count_sofa) * 100;

//             }

//         }

//     }

//     $count_sofa++;

// }

        foreach ($data as $key => $value)
        {
            if (isset($data[$key]['percentual_pacientes']))
            {
                $data[$key]['percentual_pacientes'] = ($data[$key]['total_pacientes'] / $data['total_pacientes']) * 100;
            }

            //$data[$key]['percentual_pacientes'] = number_format($data[$key]['percentual_pacientes'], 2);
        }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório Escores.pdf',
            ],
        ]);
        //$hospitalization->toArray();
        $this->set('data', $data);
        $this->set('arr_global', $arr_global);
        //$this->set('yolo', $yolo);
        $this->set('pacient_ids', $pacient_ids);
        $this->set('curb', $curb);
        $this->set('hospitalizations', $hospitalizations);
    }

//Gerenciamento de leito
    public function bedManagement()
    {
        $this->set('title', 'Mapa de Leitos');
        $data = [];

        $session = $this->request->session();
        $date_before = $session->read('date_before');
        $date_after = $session->read('date_after');
        $unit_id = $session->read('selected-unit');
        $sector_table = TableRegistry::get('Sectors');
        $hospitalizations_table = TableRegistry::get('Hospitalizations');
        $historic_table = TableRegistry::get('HistoricPatientMovements');
        //$today = date();

        $hospital_ids = [];
        $sectors_arr = [];
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $cont = 0;

        $hospital_result = $hospitalizations_table
            ->find()
            ->where(['Hospitalizations.unit_id =' => $unit_id])
            ->toArray()
        ;

//pega o id das internações separando por tipo
        foreach ($hospital_result as $key => $value)
        {
            array_push($hospital_ids, $value->id);
        }

        $patient_movement = $historic_table
            ->find()
            ->contain(['Rooms.Sectors'])
            ->where([])
            ->toArray()
        ;

        $sectors = $sector_table->find('all', [
            'contain' => [
                'Rooms.HistoricPatientMovements' => function (\Cake\ORM\Query $q)
                {
                    return $q
                        ->autoFields(true)
                    ;
                },
            ],

            'conditions' => [
                'Sectors.unit_id' => $unit_id,
            ],
        ]
        )->toArray();

        foreach ($sectors as $key => $value)
        {
            $sectors_arr[$value['id']] = $value;
            $dummy_arr = [
                "occupation" => 0,
                "available" => $value->limit_of_rooms,
                "name" => $value->name,
                "capacity" => $value->limit_of_rooms,
            ];

            for ($i = 1; $i < 9; $i++)
            {
                $data[$i]['sectors'][$value['id']] = $dummy_arr;
            }

// $data[2]['sectors'][$value['id']] = $dummy_arr;

// $data[3]['sectors'][$value['id']] = $dummy_arr;

// $data[4]['sectors'][$value['id']] = $dummy_arr;

// $data[5]['sectors'][$value['id']] = $dummy_arr;

// $data[6]['sectors'][$value['id']] = $dummy_arr;

// $data[7]['sectors'][$value['id']] = $dummy_arr;

// $data[8]['sectors'][$value['id']] = $dummy_arr;
            //array_push($data['sectors'], $dummy_arr);
        }

        foreach ($patient_movement as $key => $value)
        {
            $data_termino = null;

            if ($value['data_inicio'])
            {
                if ($value['data_termino'])
                {
                    $data_termino = date($value['data_termino']);
                }
                elseif ($value['data_previsao_alta'])
                {
                    $data_termino = date($value['data_previsao_alta']);
                }

                for ($i = 1; $i < 9; $i++)
                {
                    if (strtotime($data_termino) >= strtotime("Ymd + " . $i . " days"))
                    {
                        if (isset($data[$i]['sectors'][$value['room']['sector_id']]['occupation']))
                        {
                            $data[$i]['sectors'][$value['room']['sector_id']]['occupation']++;
                        }

                        if (isset($data[$i]['sectors'][$value['room']['sector_id']]['available']))
                        {
                            $data[$i]['sectors'][$value['room']['sector_id']]['available']--;
                        }
                    }
                }
            }
        }

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'portrait',
                'filename' => 'Relatório de gerenciamento de leito.pdf',
            ],
        ]);

        $this->set('data', $data);
        $this->set('sectors_arr', $sectors_arr);
        $this->set('patient_movement', $patient_movement);
    }

    public function prescription($id = null)
    {
        $id = 5;
        $session = $this->request->session();

        $prescription_table = TableRegistry::get('Prescriptions');
        $prescription = $prescription_table->find('all', [
            'contain' => ["Medications", "Hospitalizations.Patients"],

            'conditions' => [
                'Prescriptions.id' => $id,
            ],
        ]);

        $this->viewBuilder()->options([
            'pdfConfig' => [
                'orientation' => 'landscape',
                'filename' => 'Prescrição.pdf',
            ],
        ]);

        $prescription->toArray();
        $this->set('data', $prescription);
    }
};
