
<?php    
    echo $this->element( 'internacao-menu' );

    $specialties = [];
    if (isset($professionals[0]['specialties']) )
    {
        foreach($professionals[0]['specialties'] as $key => $value)
        {
             $specialties[$key] = $value['id'];
        }
    }
?>

<div class="medicalOpinionRequests index col-md-9 col-sm-9 columns content">
    <!-- <h3>Parecer Médico</h3> -->
    <br>   
    <?php    
        echo $this->Html->link('Novo Parecer Médico',
            ['controller' => 'MedicalOpinionRequests', 'action' => 'add']
            , array('class' => 'link-bt'));           
    ?>
    <br><br> 
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('created', ['label'=>'Data de Criação']) ?></th>
                <th><?= $this->Paginator->sort('requested_specialty_id', ['label'=>'Especialidade Requisitada']) ?></th>
                <th><?= $this->Paginator->sort('motive', ['label'=>'Motivo']) ?></th>                        
                <th><?= $this->Paginator->sort('user_id', ['label'=>'Profissional']) ?></th>                
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($medicalOpinionRequests as $medicalOpinionRequest): ?>
            <tr>
             
                
                <td><?= h($medicalOpinionRequest->created->format('d/m/Y')) ?></td> 
                <td><?= h($medicalOpinionRequest->specialty->name) ?></td>                
                <td>
                    <?php
                        echo $this->Text->truncate(
                            h($medicalOpinionRequest->motive),22,
                            [
                                'ellipsis' => '...',
                                'exact' => false
                            ]);
                     ?>
                 </td>                               
                <td>
                    <?=
                     h($medicalOpinionRequest->user->name)  
                    ?>
                    <?php //echo $medicalOpinionRequest->has('professional') ? $this->Html->link($medicalOpinionRequest->professional->id, ['controller' => 'Professionals', 'action' => 'view', $medicalOpinionRequest->professional->id]) : '' ?>
                </td>
                
                <td class="actions" style="white-space:nowrap">
                    <?php //echo $this->Html->link(__('Ver'), ['action' => 'view', $medicalOpinionRequest->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Editar'), ['action' => 'edit', $medicalOpinionRequest->id], ['class'=>'btn btn-primary btn-xs']) ?>

                    <?php if( empty( $medicalOpinionRequest->medical_opinion_answers ) ): ?>
                        <?php 
                            if(in_array($medicalOpinionRequest->specialty_id, $specialties )){
                                echo $this->Html->link(__('Responder'), ['controller'=>'medicalOpinionAnswers','action' => 'edit', $medicalOpinionRequest->id], ['class'=>'btn btn-primary btn-xs']) ;
                            }
                            
                        ?>

                     <?php else : ?>                                    
                        <?php /*echo $this->Html->link(__('Responder'), ['controller'=>'medicalOpinionAnswers','action' => 'edit', $medicalOpinionRequest->id, $medicalOpinionRequest->medical_opinion_answers[0]['id']], ['class'=>'btn btn-primary btn-xs']) */?>
                    <?php endif; ?>


                    <?php 
                        if ($medicalOpinionRequest->is_active){
                            echo $this->Form->postLink(__('Suspender'), ['action' => 'toggleMedicalRequest', $medicalOpinionRequest->id, false], ['confirm' => __('Tem certeza que deseja suspender o registro?'), 'class'=>'btn btn-danger btn-xs']);
                        }else{
                            echo $this->Form->postLink(__('Ativar'), ['action' => 'toggleMedicalRequest', $medicalOpinionRequest->id, true], ['confirm' => __('Tem certeza que deseja ativar o registro?'), 'class'=>'btn btn-primary btn-xs bt-wi-75']);

                        }
                    ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
           
        </div>
    </center>
</div>
</div>

<script >
(function() {
   // your page initialization code here
   // the DOM will be available here

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= ' <a href="/gh/users/login" class="btn btn-default"><i class="glyphicon glyphicon-home"></i></a>';          
        html+= '<a href="/gh/patients/" class="btn btn-default">Pacientes</a>';   
        html+= '<a href="/gh/hospitalizations/" class="btn btn-default">Internação</a>';  
        html+= '<a href="#" class="breadcumb-active btn btn-default">Parecer Médico</a>';          
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>