<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * BradenScales Controller
 *
 * @property \App\Model\Table\BradenScalesTable $BradenScales
 */
class BradenScalesController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Enfermagem');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'CribScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $bradenScales = $this->paginate($this->BradenScales);

        $this->set(compact('bradenScales'));
        $this->set('_serialize', ['bradenScales']);
    }

    /**
     * View method
     *
     * @param string|null $id Braden Scale id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $bradenScale = $this->BradenScales->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('bradenScale', $bradenScale);
        $this->set('_serialize', ['bradenScale']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $bradenScale = $this->BradenScales->newEntity();
        if ($this->request->is('post')) {
            $bradenScale = $this->BradenScales->patchEntity($bradenScale, $this->request->data);
            if ($this->BradenScales->save($bradenScale)) {
                $this->Flash->success(__('The braden scale has been saved.'));
                return $this->redirect(['controller' => 'FugulinBradenScales', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The braden scale could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->BradenScales->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('bradenScale', 'hospitalizations'));
        $this->set('_serialize', ['bradenScale']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Braden Scale id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $bradenScale = $this->BradenScales->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $bradenScale = $this->BradenScales->patchEntity($bradenScale, $this->request->data);
            if ($this->BradenScales->save($bradenScale)) {
                $this->Flash->success(__('The braden scale has been saved.'));
                return $this->redirect(['controller' => 'FugulinBradenScales', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The braden scale could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->BradenScales->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('bradenScale', 'hospitalizations'));
        $this->set('_serialize', ['bradenScale']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Braden Scale id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $bradenScale = $this->BradenScales->get($id);
        if ($this->BradenScales->delete($bradenScale)) {
            $this->Flash->success(__('The braden scale has been deleted.'));
        } else {
            $this->Flash->error(__('The braden scale could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
