<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;

/**
 * SafeSurgeryBundles Controller
 *
 * @property \App\Model\Table\SafeSurgeryBundlesTable $SafeSurgeryBundles
 */
class SafeSurgeryBundlesController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Bundle de Cirúrgia');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $safeSurgeryBundles = $this->paginate($this->SafeSurgeryBundles);

        $this->set(compact('safeSurgeryBundles'));
        $this->set('_serialize', ['safeSurgeryBundles']);
    }

    /**
     * View method
     *
     * @param string|null $id Safe Surgery Bundle id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $safeSurgeryBundle = $this->SafeSurgeryBundles->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('safeSurgeryBundle', $safeSurgeryBundle);
        $this->set('_serialize', ['safeSurgeryBundle']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $safeSurgeryBundle = $this->SafeSurgeryBundles->newEntity();
        if ($this->request->is('post')) {
            $safeSurgeryBundle = $this->SafeSurgeryBundles->patchEntity($safeSurgeryBundle, $this->request->data);
            if ($this->SafeSurgeryBundles->save($safeSurgeryBundle)) {
                $this->Flash->success(__('The safe surgery bundle has been saved.'));
                return $this->redirect(['controller' => 'Bundles', 'action' => 'index']);
            } else {
                $x = $safeSurgeryBundle->errors();
                Log::write('debug', 'bundle');
                Log::write('debug', $x);
                Log::write('debug', $safeSurgeryBundle);
                $this->Flash->error(__('The safe surgery bundle could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->SafeSurgeryBundles->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('safeSurgeryBundle', 'hospitalizations'));
        $this->set('_serialize', ['safeSurgeryBundle']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Safe Surgery Bundle id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $safeSurgeryBundle = $this->SafeSurgeryBundles->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $safeSurgeryBundle = $this->SafeSurgeryBundles->patchEntity($safeSurgeryBundle, $this->request->data);
            if ($this->SafeSurgeryBundles->save($safeSurgeryBundle)) {
                $this->Flash->success(__('The safe surgery bundle has been saved.'));
                return $this->redirect(['controller' => 'Bundles', 'action' => 'index']);

            } else {
                $this->Flash->error(__('The safe surgery bundle could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->SafeSurgeryBundles->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('safeSurgeryBundle', 'hospitalizations'));
        $this->set('_serialize', ['safeSurgeryBundle']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Safe Surgery Bundle id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $safeSurgeryBundle = $this->SafeSurgeryBundles->get($id);
        if ($this->SafeSurgeryBundles->delete($safeSurgeryBundle)) {
            $this->Flash->success(__('The safe surgery bundle has been deleted.'));
        } else {
            $this->Flash->error(__('The safe surgery bundle could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
