<?php
namespace App\Model\Table;

use App\Model\Entity\OtherComorbidity;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * OtherComorbidities Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $Diagnostics
 */
class OtherComorbiditiesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('other_comorbidities');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->belongsToMany('Diagnostics', [
            'foreignKey' => 'other_comorbidity_id',
            'targetForeignKey' => 'diagnostic_id',
            'joinTable' => 'other_comorbidities_diagnostics'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        return $validator;
    }
}
