<?php
namespace App\Model\Table;

use App\Model\Entity\Professional;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Professionals Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Users
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\HasMany $Bundles
 * @property \Cake\ORM\Association\HasMany $PavPreventionBundles
 * @property \Cake\ORM\Association\HasMany $ProfessionalSectors
 * @property \Cake\ORM\Association\BelongsToMany $AreasOfOccupation
 * @property \Cake\ORM\Association\BelongsToMany $Specialties
 * @property \Cake\ORM\Association\BelongsToMany $Surgeries
 */
class ProfessionalsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('professionals');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
        ]);
        $this->hasMany('Bundles', [
            'foreignKey' => 'professional_id',
        ]);
        $this->hasMany('PavPreventionBundles', [
            'foreignKey' => 'professional_id',
        ]);
        // $this->hasMany('ProfessionalSectors', [
        //     'foreignKey' => 'professional_id'
        // ]);
        $this->belongsToMany('Sectors', [
            'foreignKey'       => 'professional_id',
            'targetForeignKey' => 'sector_id',
            'joinTable'        => 'professional_sectors',
        ]);
        $this->belongsToMany('AreasOfOccupation', [
            'foreignKey'       => 'professional_id',
            'targetForeignKey' => 'areas_of_occupation_id',
            'joinTable'        => 'areas_of_occupation_professionals',
        ]);
        $this->belongsToMany('Specialties', [
            'foreignKey'       => 'professional_id',
            'targetForeignKey' => 'specialty_id',
            'joinTable'        => 'professionals_specialties',
        ]);
        $this->belongsToMany('Surgeries', [
            'foreignKey'       => 'professional_id',
            'targetForeignKey' => 'surgery_id',
            'joinTable'        => 'professionals_surgeries',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('concil_number');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['user_id'], 'Users'));
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        return $rules;
    }
}
