<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Braden Scale']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="bradenScales index col-md-10 columns content">
    <h3>Braden Scales</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('percepcao') ?></th>
                <th><?= $this->Paginator->sort('umidade') ?></th>
                <th><?= $this->Paginator->sort('atividade_fisica') ?></th>
                <th><?= $this->Paginator->sort('mobilidade') ?></th>
                <th><?= $this->Paginator->sort('nutricao_') ?></th>
                <th><?= $this->Paginator->sort('friccao') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($bradenScales as $bradenScale): ?>
            <tr>
                <td><?= $this->Number->format($bradenScale->id) ?></td>
                <td><?= h($bradenScale->percepcao) ?></td>
                <td><?= h($bradenScale->umidade) ?></td>
                <td><?= h($bradenScale->atividade_fisica) ?></td>
                <td><?= h($bradenScale->mobilidade) ?></td>
                <td><?= h($bradenScale->nutricao_) ?></td>
                <td><?= h($bradenScale->friccao) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $bradenScale->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $bradenScale->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $bradenScale->id], ['confirm' => __('Are you sure you want to delete # {0}?', $bradenScale->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>